#!/bin/bash

UPG_LIB_PATH="/opt/omm/oma/atoms/Inspect/lib"
source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }

RESULT_OF_TAR_PATH="/tmp/FusionStorage_Inspect"
NODE_IP=""

function get_fsa_out_put_info()
{
    local start_time=`date -d "4 hours ago" +%Y%m%d%H%M`
    local end_time=`date -d "4 hours" +%Y%m%d%H%M`

    log INFO "Begin to get fsa json."
    log INFO "Command 'sh /opt/dsware/update/upload/FusionStorage_Block_Inspect/CollectInfo.sh -nodeip NODE_IP -nodetype FSA -period ${start_time}-${end_time} -type Collect_match_inspect_result ${RESULT_OF_TAR_PATH}'"

    sh /opt/dsware/update/upload/FusionStorage_Block_Inspect/CollectInfo.sh -nodeip ${NODE_IP} -nodetype FSA -period ${start_time}-${end_time} -type Collect_match_inspect_result ${RESULT_OF_TAR_PATH} 2>&1 >> ${LOG_FILE}

    local list_of_remote_result=`ls ${RESULT_OF_TAR_PATH} | grep tar.gz`

    for i in ${list_of_remote_result}
    do
        local tar_result=`tar -tf ${RESULT_OF_TAR_PATH}/${i}`
        if [[ ${tar_result} =~ "FSA" ]]
        then
            tar -zxvf ${RESULT_OF_TAR_PATH}/${i} -C ${RESULT_OF_TAR_PATH}
        else
            error_status=1
            log ERROR "${i} do not include file of json."
        fi
    done

    mv ${RESULT_OF_TAR_PATH}/match/inspect_result/* ${RESULT_OF_TAR_PATH}
    rm -rf ${RESULT_OF_TAR_PATH}/*.tar.gz 2>&1 >/dev/null
    rm -rf ${RESULT_OF_TAR_PATH}/match 2>&1 >/dev/null
    rm -f  ${RESULT_OF_TAR_PATH}/log_collect_tool.log 2>&1 >/dev/null

}

function get_check_result_info()
{
    NODE_IP=$1
    error_status=0

    if [ ! -f "/opt/dsware/tools/ops_tool/infoCollect/CollectInfo.sh" ]
    then
        log ERROR "This FSM_server do not have CollectInfo.sh"
        return 1
    fi

    if [ ! -d ${RESULT_OF_TAR_PATH} ]
    then
        mkdir ${RESULT_OF_TAR_PATH}
    else
        rm -rf ${RESULT_OF_TAR_PATH}/*
    fi

    if [[ -z "${NODE_IP}" ]]
    then
        log INFO "no para. NODE_IP=all_node"
        NODE_IP="all_node"
        get_fsa_out_put_info
    elif [[ "${NODE_IP}" != "NO_FSA" ]]
    then
        get_fsa_out_put_info
    fi

    #收集当前主FSM节点json
    cp /var/log/dsware/FSM_*_inspect_result.json ${RESULT_OF_TAR_PATH} 2>&1 >/dev/null
    if [ $? -ne 0 ]
    then
        error_status=1
        log ERROR "FSM do not have file of FSM_*_inspect_result.json"
    fi

    #信息收集结果 新建目录
    mkdir -p ${RESULT_OF_TAR_PATH}/collectInfo

    #收集当前主FSM节点 信息收集结果文件txt
    cp /var/log/dsware/FSM_*_inspect_result_collect.txt ${RESULT_OF_TAR_PATH}/collectInfo 2>&1 >/dev/null
    if [ $? -ne 0 ]
    then
        error_status=1
        log ERROR "FSM do not have file of FSM_*_inspect_collect.txt"
    fi

     #纳管迁移信息收集结果 新建目录
     mkdir -p ${RESULT_OF_TAR_PATH}/smartMigtationCollectInfo

     #收集当前主FSM节点 纳管迁移信息收集结果文件json
     cp /var/log/dsware/FSM_*_smart_migration_info_collect_result.json ${RESULT_OF_TAR_PATH}/smartMigtationCollectInfo 2>&1 >/dev/null
     if [ $? -ne 0 ]
     then
         error_status=1
         log ERROR "FSM do not have file of FSM_*_smart_migration_info_collect_result.json"
     fi

     #收集当前主FSA节点 纳管迁移信息收集结果文件json
     mv ${RESULT_OF_TAR_PATH}/FSA_*_smart_migration_info_collect_result.json ${RESULT_OF_TAR_PATH}/smartMigtationCollectInfo 2>&1 >/dev/null
     if [ $? -ne 0 ]
     then
         error_status=1
         log ERROR "do not have file of FSA_*_smart_migration_info_collect_result.json"
     fi


     #将fsa节点 信息收集结果文件txt 移动到 collectInfo 目录下
     mv -f ${RESULT_OF_TAR_PATH}/*.txt ${RESULT_OF_TAR_PATH}/collectInfo 2>&1 >/dev/null

    #打包所有结果文件
    cd ${RESULT_OF_TAR_PATH}
    rm -f /opt/dsware/update/upload/FusionStorage_Block_Inspect/inspect_result.tar.gz
    tar -zcvP -f /opt/dsware/update/upload/FusionStorage_Block_Inspect/inspect_result.tar.gz ./* 2>&1 >/dev/null
    chmod 666 /opt/dsware/update/upload/FusionStorage_Block_Inspect/inspect_result.tar.gz
    chown dsware:omm -h /opt/dsware/update/upload/FusionStorage_Block_Inspect/inspect_result.tar.gz
    cd - 2>&1 >/dev/null
    rm -rf ${RESULT_OF_TAR_PATH}

    if [ ${error_status} -eq 0 ]
    then
        return 0
    else
        return 1
    fi
}

log MUST "enter [$0],para=[$@]"
get_check_result_info $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}