#!/bin/bash

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"
PATH="/sbin:/usr/sbin:/usr/local/sbin:/root/bin:/usr/local/bin:/usr/bin:/bin:/opt/omm/oma/workspace/tools"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }

checkItemId="1001"
resultCode=0
errorKey=""
params=""
originalInfo=""

#脚本入参，节点类型
NODE_TYPE=$1

function main()
{
    if [ "${NODE_TYPE}" == "Manager" ]
    then
        manager_items_check ${checkItemId}
        if [ $? -ne 0 ]
        then
            log INFO "${checkItemId} do not select, pass"
                return 0
        else
            if [[ ! -f "/opt/dsware/DSwareManagerNodeVersion" ]]
            then
                resultCode=1
                errorKey="${checkItemId}0001"
                originalInfo="${originalInfo}""/opt/dsware/DSwareManagerNodeVersion is not exist."
                FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
                return 1;
            fi

            resultCode=0
            originalInfo="${originalInfo}""command: cat /opt/dsware/DSwareManagerNodeVersion\n"
            Version=$(cat /opt/dsware/DSwareManagerNodeVersion | grep "nodeVersion" | awk -F "=" '{print $2}')
            originalInfo="${originalInfo}""result:${Version}"
            params="${params}""${Version}"
            errorKey="${checkItemId}0002"
            FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
            return 0;
        fi
    fi

    if [ "${NODE_TYPE}" == "Agent" ]
    then
        agent_items_check ${checkItemId}
        if [ $? -ne 0 ]
        then
            log INFO "${checkItemId} do not select, pass"
                return 0
        else
            if [[ ! -f "/opt/dsware/DSwareAgentNodeVersion" ]]
            then
                resultCode=1
                errorKey="${checkItemId}0001"
                originalInfo="${originalInfo}""/opt/dsware/DSwareManagerNodeVersion is not exist."

                FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
                return 1;
            fi

            resultCode=0
            originalInfo="${originalInfo}""command: cat /opt/dsware/DSwareManagerNodeVersion\n"
            Version=$(cat /opt/dsware/DSwareAgentNodeVersion | grep "nodeVersion" | awk -F "=" '{print $2}')
            originalInfo="${originalInfo}""result:${Version}"
            params="${params}""${Version}"
            errorKey="${checkItemId}0002"
            FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
            return 0;
        fi
    fi

    return ${resultCode}
}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}

##############################
#
#  错误码：
#  0001 查询失败
#  0002 当前版本:{0}
#
##############################