#!/bin/bash

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"
PATH="/sbin:/usr/sbin:/usr/local/sbin:/root/bin:/usr/local/bin:/usr/bin:/bin:/opt/omm/oma/workspace/tools"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }

checkItemId="1002"
resultCode=0
errorKey=""
params=""
originalInfo=""

#脚本入参，节点类型
NODE_TYPE=$1

function main()
{
    if [ "${NODE_TYPE}" == "Manager" ]
    then
        manager_items_check ${checkItemId}
        if [ $? -ne 0 ]
        then
            log INFO "${checkItemId} do not select, pass"
            return 0
        else
            check_main
            FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        fi
    fi

    if [ "${NODE_TYPE}" == "Agent" ]
    then
        agent_items_check ${checkItemId}
        if [ $? -ne 0 ]
        then
            log INFO "${checkItemId} do not select, pass"
            return 0
        else
            check_main
            FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        fi
    fi
    return ${resultCode}
}

function check_main()
{
    encrypt_flag=`cat /opt/omm/oma/workspace/conf/cipher.cfg | grep IsNeedEncrypt | awk -F "=" '{print $2}'`
    originalInfo="command: cat /opt/omm/oma/workspace/conf/cipher.cfg | grep IsNeedEncrypt"
    if [ -z ${encrypt_flag} ];then
        log ERROR "Comm_${checkItemId}:unok. cat /opt/omm/oma/workspace/conf/cipher.cfg fail. encrypt_flag is ${encrypt_flag}"
        resultCode=1
        errorKey="${checkItemId}0001"
        return 1
    fi
    originalInfo="${originalInfo}""\nresult:${encrypt_flag}"

    if [ ${encrypt_flag} -ne 1 ];then
        resultCode=1
        errorKey="${checkItemId}0002"
    fi

    log INFO "Comm_${checkItemId}:ok"
    return 0
}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}

##############################
#
#
#  检查FSM和FSA升级通道加密方式
#  FSM和FSA升级通道为非加密方式，会导致升级检查失败。
#  建议修改/opt/omm/oma/workspace/conf/cipher.cfg 文件中的 IsNeedEncrypt信息为1。
#
#  错误码：
#  0001 查询节点服务器类型失败。
#  0002 /opt/omm/oma/workspace/conf/cipher.cfg 文件中的 IsNeedEncrypt信息不为1。
#
##############################