#!/bin/bash

#############################################################
#
# FusionStorage存储bond是否包含了预期的IB网口
# 错误码：
#         0000 正常
#         0001 FusionStorage存储bond未包含了预期的IB网口
#
#
#############################################################

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"
PATH="/sbin:/usr/sbin:/usr/local/sbin:/root/bin:/usr/local/bin:/usr/bin:/bin:/opt/omm/oma/workspace/tools"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }

checkItemId="1003"
resultCode=0
errorKey=""
params=""
originalInfo=""

#脚本入参，节点类型
NODE_TYPE=$1

function main()
{
    if [ "${NODE_TYPE}" == "Manager" ]
    then
        manager_items_check ${checkItemId}
        if [ $? -ne 0 ]
        then
            log INFO "${checkItemId} do not select, pass"
            return 0
        else
            check_main
            FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        fi
    fi

    if [ "${NODE_TYPE}" == "Agent" ]
    then
        agent_items_check ${checkItemId}
        if [ $? -ne 0 ]
        then
            log INFO "${checkItemId} do not select, pass"
            return 0
        else
            check_main
            FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        fi
    fi
    return ${resultCode}
}

function check_main()
{
    if [[ ! -f "/opt/fc2/cfg/server_info.conf" ]]
    then
        log INFO "FSA_${checkItemId}:unok"
        resultCode=1
        originalInfo="${originalInfo}""result:/opt/fc2/cfg/server_info.conf is not exist.\n"
        return 1
    fi

    local scenario=`cat /opt/fc2/cfg/server_info.conf | grep scenario |awk -F = '{print $2}'`
    if [ $scenario != "DBaSS" ];then
        log INFO "Comm_${checkItemId}:ok"
        originalInfo="${originalInfo}""Not involved in the current scenario."
        return 0
    fi

    local ibNetworkPort=$(ibdev2netdev 2>/dev/null | grep Up | awk -F '==>' '{print $2}' | awk  '{print $1}')
    originalInfo="${originalInfo}""command:ibdev2netdev | grep Up \n"
    originalInfo="${originalInfo}""result:${ibNetworkPort}\n"

    local ibNetworkPortSlave=$(cat /proc/net/bonding/Ibond0 | grep "Slave Interface")
    originalInfo="${originalInfo}""command:cat /proc/net/bonding/Ibond0 | grep 'Slave Interface' \n"
    originalInfo="${originalInfo}""result:${ibNetworkPortSlave} \n"

    for ib in ${ibNetworkPort[@]}
    do
        local ibond=`cat /proc/net/bonding/Ibond0 | grep "Slave Interface" | grep ${ib}`
        if  [ -z "${ibond}" ]; then
            resultCode=1
            errorKey="${checkItemId}0001"
            log ERROR "The storage bond of FusionStorage does not contain the expected IB ports."
            log ERROR "Comm_${checkItemId}:unok"
            return 1
        fi
    done

    log INFO "Comm_${checkItemId}:ok"
    return 0
}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}