#!/bin/bash

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"
PATH="/sbin:/usr/sbin:/usr/local/sbin:/root/bin:/usr/local/bin:/usr/bin:/bin:/opt/omm/oma/workspace/tools"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }

checkItemId="1004"
resultCode=0
errorKey=""
params=""
originalInfo=""

#脚本入参，节点类型
NODE_TYPE=$1

function main()
{
    if [ "${NODE_TYPE}" == "Manager" ]
    then
        manager_items_check ${checkItemId}
        if [ $? -ne 0 ]
        then
            log INFO "${checkItemId} do not select, pass"
            return 0
        else
            check_main
            FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        fi
    fi

    if [ "${NODE_TYPE}" == "Agent" ]
    then
        agent_items_check ${checkItemId}
        if [ $? -ne 0 ]
        then
            log INFO "${checkItemId} do not select, pass"
            return 0
        else
            check_main
            FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        fi
    fi
    return ${resultCode}
}

function check_main()
{
    local hostname=""
    local disk=""
    local netstat=""
    local ntpq=""
    local timedatectl=""
    local kdump=""
    local getenforce=""

    searchNIC
    originalInfo="${originalInfo}""command: ethtool"
    originalInfo="${originalInfo}""\nresult:${outputNIC}"

    hostname=$(hostname)
    originalInfo="${originalInfo}""\n\ncommand: hostname"
    originalInfo="${originalInfo}""\nresult:${hostname}"

    disk=$(lsblk -l)
    originalInfo="${originalInfo}""\n\ncommand: lsblk"
    originalInfo="${originalInfo}""\nresult:${disk}"

    ntpq=$(ntpq -p)
    originalInfo="${originalInfo}""\n\ncommand: ntpq -p"
    originalInfo="${originalInfo}""\nresult:${ntpq}"

    netstat=$(netstat -rn)
    originalInfo="${originalInfo}""\n\ncommand: netstat -rn"
    originalInfo="${originalInfo}""\nresult:${netstat}"

    timedatectl=$(timedatectl)
    originalInfo="${originalInfo}""\n\ncommand: timedatectl"
    originalInfo="${originalInfo}""\nresult:${timedatectl}"

    kdump=$(/bin/systemctl status kdump.service | head -n 5)
    originalInfo="${originalInfo}""\n\ncommand: service kdump status"
    originalInfo="${originalInfo}""\nresult:${kdump}"

    getenforce=$(getenforce)
    originalInfo="${originalInfo}""\n\ncommand: getenforce"
    originalInfo="${originalInfo}""\nresult:${getenforce}"

    log INFO "Comm_${checkItemId}:ok"
    return 0
}

function checkNIC()
{
    NIC=$1
    speed=`sudo /sbin/ethtool ${NIC} | grep 'Speed' | tr -d [[:space:]] `
    duplex=`sudo /sbin/ethtool ${NIC} | grep 'Duplex' | tr -d [[:space:]] `
    port=`sudo /sbin/ethtool ${NIC} | grep 'Port' `
    linkDetected=`sudo /sbin/ethtool ${NIC} | grep 'Link detected'`
}

function searchNIC()
{
    #非智能网卡
    ethAllFile="/opt/dsware/update/work/Precheck/update/atoms/precheck/ethinfo.all"
    ethTypeFile="/opt/dsware/update/work/Precheck/update/atoms/precheck/ethinfo.type"
    sudo /sbin/lspci | grep Ethernet | cut -d":" -f3 > $ethAllFile
    cat $ethAllFile | sort -u > $ethTypeFile

    phyNetCard=""
    while read line
    do
        num=`cat $ethAllFile | grep -F "$line" | wc -l `
        if [ -z "$phyNetCard" ]; then
            phyNetCard="$num * $line"
        else
            phyNetCard=$phyNetCard" | $num * $line"
        fi
    done < $ethTypeFile

    rm -rf $ethAllFile
    rm -rf $ethTypeFile

    logicNetCard=""
    nctcheth=`sudo /sbin/lspci -n -m | grep "0200" | grep -v "184e" | grep -v "1004" | awk '{print $1}'`

    #用来临时存放eth的值
    tempethvalue=""
    #循环获取nctcheth值
    for line in $nctcheth
    do
        tempvalue=`ls /sys/bus/pci/devices/0000:${line}/net`
        #如果第一次放值前面不加","
        if [ -n "$tempethvalue" ];then
          tempethvalue="${tempethvalue},$tempvalue"
        else
          tempethvalue="$tempvalue"
        fi
    done
    curEth="$tempethvalue"
    Eths=`echo $curEth | tr -s ',' '\n' | sort -u | tr '\n' ' '`
    for ethItem in ${Eths[*]}
    do
        checkNIC "$ethItem"
        if [ -z "$logicNetCard" ] ; then
          logicNetCard="$ethItem    $speed,$duplex,$port,$linkDetected"
        else
          logicNetCard=$logicNetCard" \n $ethItem    $speed,$duplex,$port,$linkDetected"
        fi
    done

    if [ -z "$phyNetCard" ]
    then
        outputNIC="$logicNetCard"
    else
        outputNIC="$phyNetCard \n $logicNetCard"
    fi
}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}

