#!/bin/bash

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }

checkItemId="8"
resultCode=0
errorKey=""
params=""
originalInfo=""

#脚本入参，节点类型
NODE_TYPE=$1

function check_main()
{
    if [[ -d "/opt/dsware/update/backup" && -d "/opt/dsware/update/work" ]]
    then
        local bkFileNum="$(ls /opt/dsware/update/backup | wc -l)"
        originalInfo="command:ls /opt/dsware/update/backup\n"
        originalInfo="${originalInfo}""review:$(ls /opt/dsware/update/backup)\n"

        local wkFileNum="$(ls /opt/dsware/update/work | grep -v Precheck | wc -l)"
        originalInfo="${originalInfo}""command:ls /opt/dsware/update/work \n"
        originalInfo="${originalInfo}""review:$(ls /opt/dsware/update/work |grep -v Precheck)\n"

        if [ ${bkFileNum} -eq 0 -a ${wkFileNum} -eq 0 ]
        then
            originalInfo="${originalInfo}""result:Comm_check_backup_dir:ok"
            log INFO "${checkItemId}:Comm_check_backup_dir:ok"
            return 0
        else
            if [ ${bkFileNum} -ne 0 -a ${wkFileNum} -eq 0 ]
            then
                resultCode=1
                errorKey="${checkItemId}0002"    #  0002 /opt/dsware/update/backup 目录下有残留
                originalInfo="${originalInfo}""result:/opt/dsware/update/backup is not empty\n"
                log ERROR "${checkItemId}Comm_check_backup_dir:/opt/dsware/update/backup is not empty"
                return 1
            fi

            if [ ${bkFileNum} -eq 0 -a ${wkFileNum} -ne 0 ]
            then
                resultCode=1
                errorKey="${checkItemId}0003"    #  0003 /opt/dsware/update/work 目录下有残留
                originalInfo="${originalInfo}""result:/opt/dsware/update/work is not empty\n"
                log ERROR "${checkItemId}Comm_check_backup_dir:/opt/dsware/update/work is not empty"
                return 1
            fi

            resultCode=1
            errorKey="${checkItemId}0004"    #  0004 /opt/dsware/update/backup 和 /opt/dsware/update/work 目录下都有残留
            originalInfo="${originalInfo}""result:/opt/dsware/update/backup and /opt/dsware/update/work are not empty\n"
            log ERROR "${checkItemId}:Comm_check_backup_dir:/opt/dsware/update/backup and /opt/dsware/update/work are not empty"
            log ERROR "${checkItemId}:Comm_check_backup_dir:unok"
            return 1
        fi
    else
        resultCode=1
        errorKey="${checkItemId}0001"    #  0001 /opt/dsware/update/backup 或者 /opt/dsware/update/work 目录不存在
        originalInfo="command:cd /opt/dsware/update/backup ; cd /opt/dsware/update/work\n"
        originalInfo="${originalInfo}""review:/opt/dsware/update/backup or /opt/dsware/update/work not found.\n"
        originalInfo="${originalInfo}""result:/opt/dsware/update/backup or /opt/dsware/update/work does not exist"
        log ERROR "${checkItemId}Comm_check_backup_dir:/opt/dsware/update/backup or /opt/dsware/update/work does not exist"
        log ERROR "${checkItemId}:Comm_check_backup_dir:unok"
        return 1
    fi
}

function check_jre_link()
{
    jre_info=$(ls -l /opt/dsware/agent/jre-*.tar.gz)
    originalInfo="${originalInfo}\n""command:ls -l /opt/dsware/agent/jre-*.tar.gz"
    originalInfo="${originalInfo}\n""review:${jre_info}"

    jre_num=$(ls /opt/dsware/agent/jre-*.tar.gz|wc -l)
    if [[ ${jre_num} -gt 1 ]]
    then
        log ERROR "${jre_info}"
        resultCode=1
        if [[ -z "${errorKey}" ]]
        then
            errorKey="${checkItemId}0005"
        else
            errorKey="${checkItemId}0006"
        fi
    fi
}

function main()
{
    check_main

    if [ "${NODE_TYPE}" == "Agent" ]
    then
        check_jre_link
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
    fi

    if [ "${NODE_TYPE}" == "Manager" ]
    then
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
    fi

    return "${resultCode}"
}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}

##############################
#
#  错误码：
#  0001 /opt/dsware/update/backup 或者 /opt/dsware/update/work 目录不存在
#  0002 /opt/dsware/update/backup 目录下有残留
#  0003 /opt/dsware/update/work 目录下有残留
#  0004 /opt/dsware/update/backup 和 /opt/dsware/update/work 目录下都有残留
#
##############################