#!/bin/bash

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }

checkItemId="29"
resultCode=0
errorKey=""
params=""
originalInfo=""

#脚本入参，节点类型
NODE_TYPE=$1

main()
{
    local encryption_status=`grep IsNeedEncrypt /opt/omm/oma/workspace/conf/cipher.cfg | awk -F '=' '{print $2}'|grep -w 1`
    originalInfo="command:grep IsNeedEncrypt /opt/omm/oma/workspace/conf/cipher.cfg | awk -F '=' '{print \$2}'|grep -w 1\n"
    originalInfo="${originalInfo}""review:${encryption_status}\n"
    
    if [[ -n ${encryption_status} ]]
    then
        originalInfo="${originalInfo}""result:Encryption Config Info:ok"
        log INFO "${checkItemId}:Comm_check_cipher_cfg.sh:ok"
        if [ "${NODE_TYPE}" == "Agent" ]
        then
            FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        fi

        if [ "${NODE_TYPE}" == "Manager" ]
        then
            FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        fi
        return 0
    else
        resultCode=1
        errorKey="${checkItemId}0001"    # 0001 加密文件配置不正确，cipher.cfg 文件中 IsNeedEncrypt 值不为 1
        originalInfo="${originalInfo}""result:cipher.cfg configuration is wrong."
        log ERROR "${checkItemId}Comm_check_cipher_cfg:cipher.cfg configuration is wrong."
        log ERROR "${checkItemId}:Comm_check_cipher_cfg:unok"
        if [ "${NODE_TYPE}" == "Agent" ]
        then
            FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        fi

        if [ "${NODE_TYPE}" == "Manager" ]
        then
            FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        fi
        return 1
    fi
}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}

##############################
#
#  错误码：
#  0001 加密文件配置不正确，cipher.cfg 文件中 IsNeedEncrypt 值不为 1
#
##############################