#!/bin/bash

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"
source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }

#输出到json文件中的checkItemId,每个检查脚本一个id
checkItemId="16"
resultCode=0
errorKey=""
params=""
originalInfo=""

#脚本入参，节点类型
NODE_TYPE=$1
#检查文件
cipher_file="/opt/omm/oma/workspace/conf/cipher.cfg"
#获取源版本
src_version="$(get_src_version)"

function check_main()
{
    ret=$(cat ${cipher_file}| grep KeyManagerType= | awk -F'=' '{print $2}')
    if [[ "${ret}" != "KMC" ]]
    then
        log ERROR "KeyManagerType=${ret} is not KMC."
        resultCode=1
        errorKey="160001"
    fi
    originalInfo="command:cat ${cipher_file}| grep KeyManagerType= | awk -F'=' '{print \$2}' \n""${ret}"
    return 0
}

function main()
{
    if [[ ${src_version} == V100R006* ]]
    then
        log INFO "Current version is ${src_version}, begin to check KMC."
        check_main
    else
        originalInfo="Current version is ${src_version}, no need to check KMC in ${cipher_file}"
        log INFO "${originalInfo}"
    fi

    if [ "${NODE_TYPE}" == "Agent" ]
    then
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
    fi

    if [ "${NODE_TYPE}" == "Manager" ]
    then
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
    fi

    return "${resultCode}"
}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}