#!/bin/bash

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"
source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }

#输出到json文件中的checkItemId,每个检查脚本一个id
checkItemId="18"
resultCode=0
errorKey=""
params=""
originalInfo=""

#脚本入参，节点类型
NODE_TYPE=$1

#SUSE系列的操作系统和RedHat系列的操作系统的cron服务以及cron配置文件路径稍有不同
cron_user="root"
SUSE_cron_service="cron"
SUSE_cron_cfg_file="/var/spool/cron/tabs/${cron_user}"
RedHat_cron_service="crond"
RedHat_cron_cfg_file="/var/spool/cron/${cron_user}"
cron_oma_key="oma_monitor"
cron_cfg_file=""

function get_os_cron_cfg()
{
    if [ -f "/etc/init.d/crond" -o  -f "/usr/lib/systemd/system/crond.service" ] ; then
        cron_service="${RedHat_cron_service}"
        cron_cfg_file="${RedHat_cron_cfg_file}"
    elif [ -f "/etc/init.d/cron" -o -f "/usr/lib/systemd/system/cron.service" ] ; then
        cron_service="${SUSE_cron_service}"
        cron_cfg_file="${SUSE_cron_cfg_file}"
    else
        log ERROR "OS type invalid, can not get crontab cfg."
    fi

    if [ ! -f "${cron_cfg_file}" ]
    then
        log ERROR "file ${cron_cfg_file} not exist."
        originalInfo="${cron_cfg_file} not exist."
        resultCode=1
        errorKey="180001"
        return 1
    fi
    return 0
}

function monitor_OMA_cron_status()
{
    tmp=$(cat "${cron_cfg_file}"|grep -v "\""| grep -v '\\')
    originalInfo="command:cat ${cron_cfg_file}""\n${tmp}"

    ret=$(cat "${cron_cfg_file}" | grep -w ${cron_oma_key} |grep -vE "^#")
    if [ -z "${ret}" ] ; then
        log ERROR "no oma_monitor in ${cron_cfg_file}."
        originalInfo="${originalInfo}""\nERROR:no oma_monitor in ${cron_cfg_file}."
        resultCode=1
        errorKey="180002"
        return 1
    fi
    return 0
}

function oma_monitor_run_check()
{
    oma_monitor_run_pro=""

    for temp in {1..5}
    do
        oma_monitor_run_pro="$(ps -efww | grep -w ${cron_oma_key} | grep -v grep)"
        if [ -n "${oma_monitor_run_pro}" ]
        then
            log INFO "${oma_monitor_run_pro}"
            originalInfo="${originalInfo}\n""command:ps -efww | grep -w ${cron_oma_key} | grep -v grep""\n${oma_monitor_run_pro}"
            return 0
        fi
        log ERROR "no oma_monitor process is running. check count=${temp}"
        sleep 2
    done

    if [ -z "${oma_monitor_run_pro}" ]
    then
        originalInfo="${originalInfo}\n""\ncommand:ps -efww | grep -w ${cron_oma_key} | grep -v grep""\nERROR:no oma_monitor process is running"
        resultCode=1
        errorKey="180002"
        return 1
    fi
}


function check_main()
{
    if [ -f /usr/bin/FusionStorageAgentControl ] ; then
        originalInfo="/usr/bin/FusionStorageAgentControl is exist, no need to check oma_monitor in crontab."
        return 0
    fi

    get_os_cron_cfg || return 1

    monitor_OMA_cron_status || return 1

    oma_monitor_run_check || return 1

    return 0
}


function main()
{
    check_main

    if [ "${NODE_TYPE}" == "Agent" ]
    then
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
    fi

    if [ "${NODE_TYPE}" == "Manager" ]
    then
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
    fi

    return "${resultCode}"
}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}