#!/bin/bash

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"
source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }

#输出到json文件中的checkItemId,每个检查脚本一个id
checkItemId="15"
resultCode=0
errorKey=""
params=""
originalInfo=""

#脚本入参，节点类型
NODE_TYPE=$1

function check_main()
{
    local checkTools="/opt/omm/oma/workspace/tools/status_oma_app"
    local info=""
    local subResult=""
    for temp in {1..5}
    do
        info=$(${checkTools})
        subResult=$(${checkTools} | grep -vw "is running")
        if [ -z "${subResult}" ]
        then
            log INFO "${info}"
            originalInfo="command:/opt/omm/oma/workspace/tools/status_oma_app""\n${info}"
            return 0
        fi
        log ERROR "Some process abnormal: ${subResult}. check count=${temp}"
        sleep 2
    done

    if [ -n "${subResult}" ]
    then
        originalInfo="command:/opt/omm/oma/workspace/tools/status_oma_app""\n${info}"
        resultCode=1
        errorKey="150001"
        return 1
    fi
}


function main()
{
    check_main

    if [ "${NODE_TYPE}" == "Agent" ]
    then
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
    fi

    if [ "${NODE_TYPE}" == "Manager" ]
    then
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
    fi

    return "${resultCode}"
}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}