#!/bin/bash

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"
source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }

#输出到json文件中的checkItemId,每个检查脚本一个id
checkItemId="17"
resultCode=0
errorKey=""
params=""
originalInfo=""

#脚本入参，节点类型
NODE_TYPE=$1

#待检查的系统配置文件
sysCfgFile="/etc/sysctl.conf"

function main()
{
    if [ -f "${sysCfgFile}" ]
    then
        info=$(lsattr ${sysCfgFile})
        originalInfo="command:lsattr ${sysCfgFile}""\n${info}"

        canModify=$(echo ${info} | grep "^....i")

        if [ -n "$canModify" ]
        then
            log ERROR "${sysCfgFile} can't be modified, $canModify"
            resultCode=1
            errorKey="170001"
        fi
    else
        originalInfo="${sysCfgFile} not exist."
        resultCode=1
        errorKey="170002"
    fi

    if [ "${NODE_TYPE}" == "Agent" ]
    then
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
    fi

    if [ "${NODE_TYPE}" == "Manager" ]
    then
        FSM_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
    fi

    return ${resultCode}
}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}