#!/bin/bash
#检查g_net_crc_check_flag参数是否一致

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"
PATH="/sbin:/usr/sbin:/usr/local/sbin:/root/bin:/usr/local/bin:/usr/bin:/bin:/opt/omm/oma/workspace/tools"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }

checkItemId="1202"
resultCode=0
errorKey=""
params=""
originalInfo=""

#脚本入参，节点类型
NODE_TYPE=$1

function main()
{
    agent_items_check ${checkItemId}
    if [ $? -ne 0 ]
    then
        log INFO "${checkItemId} do not select, pass"
        return 0
    else
        check_main
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
    fi
    return ${resultCode}
}

function check_main()
{
    osd_check_flag=`cat /opt/dsware/osd/conf/osd_*_conf.cfg | grep g_net_crc_check_flag | awk -F "=" '{print $2}'`
    originalInfo="cat /opt/dsware/osd/conf/osd_*_conf.cfg | grep g_net_crc_check_flag\n"
    originalInfo="${originalInfo}result:${osd_check_flag}\n"

    vbs_check_flag=`cat /opt/dsware/vbs/conf/vbs_*_conf.cfg | grep g_net_crc_check_flag | awk -F "=" '{print $2}'`
    originalInfo="${originalInfo}cat /opt/dsware/osd/conf/vbs_*_conf.cfg | grep g_net_crc_check_flag\n"
    originalInfo="${originalInfo}result:${vbs_check_flag}\n"

    mdc_check_flag=`cat /opt/dsware/mdc/conf/mdc_*.cfg | grep g_net_crc_check_flag | awk -F "=" '{print $2}'`
    originalInfo="${originalInfo}cat /opt/dsware/osd/conf/mdc_*_conf.cfg | grep g_net_crc_check_flag\n"
    originalInfo="${originalInfo}result:${mdc_check_flag}\n"

    res=$(echo "${originalInfo}" | grep "false" | grep "true")
    if  [ ! -z "${res}" ]; then
        resultCode=1
        log INFO "FSA_${checkItemId}:unok"
        return 1
    else
        resultCode=0
        log INFO "FSA_${checkItemId}:ok"
        return 0
    fi

}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}

##############################
#
#
#  判断crc参数是否一致
#  如果crc参数不一致，升级后存储池可能故障，升级前需要确保g_net_crc_check_flag参数一致。
#  建议将所有mdc、vbs、osd的配置文件中该参数修改为一致，并且停业务，重新进场生效配置
#
#
##############################