#!/bin/bash
#排除DBN节点udisks内存泄漏风险

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"
PATH="/sbin:/usr/sbin:/usr/local/sbin:/root/bin:/usr/local/bin:/usr/bin:/bin:/opt/omm/oma/workspace/tools"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }

checkItemId="1203"
resultCode=0
errorKey=""
params=""
originalInfo=""

function main()
{
    agent_items_check ${checkItemId}
    if [ $? -ne 0 ]
    then
        log INFO "${checkItemId} do not select, pass"
        return 0
    fi

    if [[ ! -f "/opt/fc2/cfg/server_info.conf" ]]
    then
        log INFO "/opt/fc2/cfg/server_info.conf is not exist."
        originalInfo="${originalInfo}""/opt/fc2/cfg/server_info.conf is not exist.\n"
        resultCode=1
        errorKey="${checkItemId}0001"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1;
    fi

    local nodeType=$(cat /opt/fc2/cfg/server_info.conf | grep "nodeType" | awk -F '=' '{print $2}')
    originalInfo="${originalInfo}""command: cat /opt/fc2/cfg/server_info.conf\n"
    originalInfo="${originalInfo}""result: ${nodeType}\n"
    if  [ "${nodeType}" != "DBN" ]; then
        log INFO "The nodeType is not DBN."
        resultCode=0
        errorKey="${checkItemId}0002"
        originalInfo="${originalInfo}""The current node is not involved."
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

    local udisksVersion="$(rpm -qa | grep -n "^udisks" | awk -F ":" '{print $2}')"
    originalInfo="${originalInfo}""command: rpm -qa | grep -n '^udisks'\n"
    originalInfo="${originalInfo}""result: ${udisksVersion}\n"
    if [[ -z "${udisksVersion}" ]]
    then
        resultCode=1
        errorKey="${checkItemId}0001"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1;
    fi
    params="${params}"",${udisksVersion}"

    if [ "udisks-1.0.1-11" '>' "${udisksVersion}" ]; then
        resultCode=1
        errorKey="${checkItemId}0004"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1;
    fi

    resultCode=0
    errorKey="${checkItemId}0003"
    FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
    return 0
}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}

##############################
#
#  错误码：
#  0001 查询失败
#  0002 OS版本:{0}\nudisks版本:{1}
#
##############################