#!/bin/bash

#############################################################
#
# 名  称：检查DBN节点hung_task_panic设置
# 错误码：
#         0000 正常
#         0001 配置文件不存在
#         0002 kernel.hung_task_panic=1，表示启用了hung_task_panic 存在操作系统异常重启的风险。
#
#
#############################################################

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }

checkItemId="1204"
resultCode=0
errorKey=""
params=""
originalInfo=""

function main()
{
    agent_items_check ${checkItemId}
    if [ $? -ne 0 ]
    then
       log INFO "${checkItemId} do not select, pass"
       return 0
    fi

    if [[ ! -f "/opt/fc2/cfg/server_info.conf" ]]
    then
        resultCode=1
        errorKey="${checkItemId}0001"
        originalInfo="${originalInfo}""/opt/fc2/cfg/server_info.conf is not exist."
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1;
    fi

    local nodeType=$(cat /opt/fc2/cfg/server_info.conf | grep "nodeType" | awk -F '=' '{print $2}')
    originalInfo="${originalInfo}""command: cat /opt/fc2/cfg/server_info.conf\n"
    originalInfo="${originalInfo}""result: ${nodeType}\n"
    if  [ "${nodeType}" != "DBN" ]; then
        log INFO "The nodeType is not DBN."
        resultCode=0
        errorKey="${checkItemId}0003"
        originalInfo="${originalInfo}""The current node is not involved."
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

    local hung_task_panic=`cat /proc/sys/kernel/hung_task_panic`
    originalInfo="${originalInfo}""command: cat  /proc/sys/kernel/hung_task_panic\n"
    originalInfo="${originalInfo}""result: ${hung_task_panic}\n"
    if [ $hung_task_panic -eq 1 ];then
        resultCode=1
        errorKey="${checkItemId}0002"   # kernel.hung_task_panic=1，表示启用了hung_task_panic
        log ERROR "kernel.hung task panic is open."
        log ERROR "FSA_${checkItemId}:unok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    else
        log INFO "FSM_${checkItemId}:result:hung task anic is close"
        log INFO "FSM_${checkItemId}:ok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi
}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}
