#!/bin/bash

#############################################################
#
# 名  称：检查数据库节点操作系统版本
# 错误码：
#         0000 正常
#         0001 server_info.conf 配置文件不存在
#         0002 rhel6.X 则需要删除防火墙定时任务。
#         0003 rhel 7.6，FusionStorage为V100R006C30SPH505，需要检查vbs.ko文件
#
#############################################################

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }

checkItemId="1205"
resultCode=0
errorKey=""
params=""
originalInfo=""

function main()
{
    agent_items_check ${checkItemId}
    if [ $? -ne 0 ]
    then
       log INFO "${checkItemId} do not select, pass"
       return 0
    fi

    if [[ ! -f "/opt/fc2/cfg/server_info.conf" ]]
    then
        resultCode=1
        errorKey="${checkItemId}0001"
        originalInfo="${originalInfo}""/opt/fc2/cfg/server_info.conf is not exist.\n"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1;
    fi

    local nodeType=$(cat /opt/fc2/cfg/server_info.conf | grep "nodeType" | awk -F '=' '{print $2}')
    originalInfo="${originalInfo}""command: cat /opt/fc2/cfg/server_info.conf\n"
    originalInfo="${originalInfo}""result: ${nodeType}\n"
    if  [ "${nodeType}" != "DBN" ]; then
        log INFO "The nodeType is not DBN."
        resultCode=0
        errorKey="${checkItemId}0004"
        originalInfo="${originalInfo}""The current node is not involved."
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

    local fsVersion=`cat /opt/dsware/DSwareAgentNodeVersion | grep nodeVersion  | awk -F '=' '{print $2}'`
    originalInfo="${originalInfo}""command: cat /opt/dsware/DSwareAgentNodeVersion | grep nodeVersion \n"
    originalInfo="${originalInfo}""result:${fsVersion}.\n"
    if [ "${fsVersion}" '<' "V100R006C30SPC300" ]; then
        log INFO "FSA_${checkItemId}:ok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

    local conntrack=`cat /var/log/messages | grep "nf_conntrack:table full, dropping packet"`
    originalInfo="${originalInfo}""command: cat /var/log/messages | grep 'nf_conntrack:table full, dropping packet'\n"
    originalInfo="${originalInfo}""result:${conntrack}.\n"
    if [ -z "${conntrack}" ]
    then
        log INFO "FSA_${checkItemId}:ok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    else
        resultCode=1
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi
}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}
