#!/bin/bash

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"
PATH="/sbin:/usr/sbin:/usr/local/sbin:/root/bin:/usr/local/bin:/usr/bin:/bin:/opt/omm/oma/workspace/tools"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }

checkItemId="1206"
resultCode=0
errorKey=""
params=""
originalInfo=""

function main()
{
    agent_items_check ${checkItemId}
    if [ $? -ne 0 ]
    then
        log INFO "${checkItemId} do not select, pass"
        return 0
    fi

    if [[ ! -f "/opt/fc2/cfg/server_info.conf" ]]
    then
        log INFO "/opt/fc2/cfg/server_info.conf is not exist."
        originalInfo="${originalInfo}""/opt/fc2/cfg/server_info.conf is not exist."
        resultCode=1
        errorKey="${checkItemId}0001"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1;
    fi

    local nodeType=$(cat /opt/fc2/cfg/server_info.conf | grep "nodeType" | awk -F '=' '{print $2}')
    if  [ "${nodeType}" != "DBN" ]; then
        log INFO "The nodeType is not DBN."
        errorKey="${checkItemId}0002"
        originalInfo="${originalInfo}""The current node is not involved."
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

    local ibondNum=$(find /etc -name ifcfg-Ibond* | wc -l 2> /dev/null)
    originalInfo="${originalInfo}""command: find /etc -name ifcfg-Ibond* | wc -l 2\n"
    originalInfo="${originalInfo}""result: ibondNum:${ibondNum}\n"
    if [ 0 -ge $ibondNum ]; then
        errorKey="${checkItemId}0003"
        log INFO "The number of ibonds on the node is ${ibondNum}."
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

    local i=0
    for (( i; i<(${ibondNum}); i++ ))
    do
        local ibondName="/etc/sysconfig/network-scripts/ifcfg-Ibond${i}"
        if [[ ! -f "${ibondName}" ]]
        then
            log ERROR "The ${ibondNum} information of the node is empty."
            break
        fi
        local mtuNum=$(cat ${ibondName} | grep "MTU")
        originalInfo="${originalInfo}""command: cat ${ibondName} | grep "MTU"\n"
        originalInfo="${originalInfo}""result: MTU ${mtuNum}\n"
        if [[ -n "${mtuNum}" ]]
        then
            params="${params}""Ibond${i}"":${mtuNum}\n"
        fi
    done

    resultCode=0
    errorKey="${checkItemId}0004"
    FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
    return 0
}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}

##############################
#
#  错误码：
#  0001 查询失败
#  0002 OS版本:{0}\nudisks版本:{1}
#  0003=存在udisks内存泄漏的风险
#
##############################