#!/bin/bash

#############################################################
#
# 名  称：检查IB绑定网卡配置
# 错误码：
#         0000 正常
#         0001 无IB网口或未启用IB网卡
#         0002 IB网口未配置BONDING_SLAVE参数
#
#############################################################

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }

checkItemId="1207"
resultCode=0
errorKey=""
params=""
originalInfo=""

function main()
{
    agent_items_check ${checkItemId}
    if [ $? -ne 0 ]
    then
       log INFO "${checkItemId} do not select, pass"
       return 0
    fi

    if [[ ! -f "/opt/fc2/cfg/server_info.conf" ]]
    then
        log INFO "FSA_${checkItemId}:unok"
        resultCode=1
        originalInfo="${originalInfo}""result:/opt/fc2/cfg/server_info.conf is not exist.\n"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi

    local scenario=`cat /opt/fc2/cfg/server_info.conf | grep scenario |awk -F = '{print $2}'`
    if [ $scenario != "DBaSS" ];then
        log INFO "FSA_${checkItemId}:ok"
        originalInfo="${originalInfo}""Not involved in the current scenario."
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

    local network_port_ib=$(ibdev2netdev 2>/dev/null | grep Up | awk -F '==>' '{print $2}' | awk  '{print $1}')
    originalInfo="${originalInfo}""command:ibdev2netdev\n"
    originalInfo="${originalInfo}""result:${network_port_ib}\n"
    if [[ -z ${network_port_ib} ]];then
        resultCode=0
        errorKey="${checkItemId}0001"   # 无IB网口或未启用IB网卡
        log ERROR "no network_port_ib or unused network_port_ib."
        log ERROR "FSA_${checkItemId}:unok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi
    local bondingSlave=$(cat /etc/sysconfig/network-scripts/ifcfg-Ibond* | grep BONDING_SLAVE)
    originalInfo="${originalInfo}""command:cat /etc/sysconfig/network-scripts/ifcfg-Ibond* | grep BONDING_SLAVE\n"
    originalInfo="${originalInfo}""result:${bondingSlave}\n"
    for ib_port in ${network_port_ib}
    do
        cat /etc/sysconfig/network-scripts/ifcfg-Ibond* | grep BONDING_SLAVE | grep ${ib_port}
        if [ $? -ne 0 ];then
            resultCode=1
            errorKey="${checkItemId}0002"   # IB网口未配置BONDING_SLAVE参数
            log ERROR "network_port_ib = ${ib_port} is not configure BONDING_SLAVE."
            log ERROR "FSA_${checkItemId}:unok"
            FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
            return ${resultCode}
        fi
    done

    resultCode=0
    log INFO "FSA_${checkItemId}:ok"
    FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
    return ${resultCode}
}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}

