#!/bin/bash

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"
PATH="/sbin:/usr/sbin:/usr/local/sbin:/root/bin:/usr/local/bin:/usr/bin:/bin:/opt/omm/oma/workspace/tools"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }

checkItemId="1208"
resultCode=0
errorKey=""
params=""
originalInfo=""

#脚本入参，节点类型
NODE_TYPE=$1

function main()
{
    agent_items_check ${checkItemId}
    if [ $? -ne 0 ]
    then
        log INFO "${checkItemId} do not select, pass"
        return 0
    else
        check_main
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
    fi

    return ${resultCode}
}

function check_main()
{
    hardwareModel=$(dmidecode -s system-product-name)
    originalInfo="command:dmidecode -s system-product-name\n"
    hardwareModel=$(echo $hardwareModel | tr '[a-z]' '[A-Z]')
    if [ -z ${hardwareModel} ];then
        log ERROR "FSA_${checkItemId}:unok. hardwareModel is ${hardwareModel}"
        resultCode=1
        errorKey="${checkItemId}0001"
        originalInfo="${originalInfo}result:${hardwareModel}"
        return 1
    fi
    originalInfo="${originalInfo}result:${hardwareModel}"
    if [ "XH628 V5" == "${hardwareModel}" ];then
        resultCode=1
        errorKey="${checkItemId}0002"
        log ERROR "If the server type is XH628 V5, use the FusionCube one-click upgrade mode."
        return 1
    fi

    log INFO "FSA_${checkItemId}:ok"
    return 0
}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}

##############################
#
#
#  判断当前机型是否是XH628 V5,如果是不推荐用户使用工具升级
#  如果是XH628 V5,如果是不推荐用户使用工具升级，切换FusionCube一键式升级
#
#  错误码：
#  0001 查询节点服务器类型失败。
#  0002 服务器类型为XH628 V5，请使用FusionCube一键式升级。
#
##############################