#!/bin/bash

#############################################################
#
# 名  称：检查opensm强制扫描功能开启状态
# 错误码：
#         0000 正常
#         0001 opensm强制扫描功能未配置
#         0002 opensm强制扫描功能开启true
#
#############################################################

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"
PATH="/sbin:/usr/sbin:/usr/local/sbin:/root/bin:/usr/local/bin:/usr/bin:/bin:/opt/omm/oma/workspace/tools"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }

checkItemId="1209"
resultCode=0
errorKey=""
params=""
originalInfo=""

function main()
{
    agent_items_check ${checkItemId}
    if [ $? -ne 0 ]
    then
       log INFO "${checkItemId} do not select, pass"
       return 0
    fi

    if [[ ! -f "/opt/fc2/cfg/server_info.conf" ]]
    then
        log INFO "FSA_${checkItemId}:unok"
        resultCode=1
        originalInfo="${originalInfo}""result:/opt/fc2/cfg/server_info.conf is not exist.\n"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi

    local scenario=`cat /opt/fc2/cfg/server_info.conf | grep scenario |awk -F = '{print $2}'`
    if [ $scenario != "DBaSS" ];then
        log INFO "FSA_${checkItemId}:ok"
        originalInfo="${originalInfo}""Not involved in the current scenario."
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

    if [[ ! -f "/etc/opensm/opensm.conf" ]]
    then
        log INFO "/etc/opensm/opensm.conf is not exist."
        originalInfo="${originalInfo}""/etc/opensm/opensm.conf is not exist.\n"
        resultCode=1
        errorKey="${checkItemId}0003"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1;
    fi

    local heavy_sweep_result=`cat /etc/opensm/opensm.conf | grep force_heavy_sweep | awk '{print $2}'`
    originalInfo="${originalInfo}""command:cat /etc/opensm/opensm.conf | grep force_heavy_sweep\n"
    originalInfo="${originalInfo}""result:${heavy_sweep_result}\n"
    if [ -z ${heavy_sweep_result} ];then
        resultCode=1
        errorKey="${checkItemId}0001"   # opensm强制扫描功能未配置
        originalInfo="${originalInfo}""command:cat /etc/opensm/opensm.conf | grep force_heavy_sweep\n"
        originalInfo="${originalInfo}""result:opensm is not configure.\n"
        log ERROR "Gateway is not configure."
        log ERROR "FSA_${checkItemId}:unok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi

    if [ ${heavy_sweep_result} == "true" ] || [ ${heavy_sweep_result} == "TRUE" ];then
        resultCode=1
        errorKey="${checkItemId}0002"   # opensm强制扫描功能开启true
        log ERROR "result:opensm result is true."
        log ERROR "FSA_${checkItemId}:unok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    else
        log INFO "FSA_${checkItemId}:result:opensm result is false."
        log INFO "FSA_${checkItemId}:ok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}


