#!/bin/bash

#############################################################
#
# 检查FusionCompute主机中fusioncube_Irq_Affinity.sh的文件属性
# 错误码：
#         0000 正常
#         0001 文件权限不正确
#
#############################################################

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }

checkItemId="1211"
resultCode=0
errorKey=""
params=""
originalInfo=""

function main()
{
    agent_items_check ${checkItemId}
    if [ $? -ne 0 ]
    then
       log INFO "${checkItemId} do not select, pass"
       return 0
    fi

    if [[ ! -f "/opt/fc2/cfg/server_info.conf" ]]
    then
        log INFO "FSA_${checkItemId}:unok"
        resultCode=1
        originalInfo="${originalInfo}""result:/opt/fc2/cfg/server_info.conf is not exist.\n"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi

    local scenario=`cat /opt/fc2/cfg/server_info.conf | grep scenario |awk -F = '{print $2}'`
    if [ $scenario != "FusionsphereIaSS" ];then
        log INFO "FSA_${checkItemId}:ok"
        originalInfo="${originalInfo}""Not involved in the current scenario."
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

    if [ -d "/opt/goku/tomcat/bin" ]; then
        log INFO "FSA_${checkItemId}:ok"
        originalInfo="${originalInfo}""The current node is not involved."
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

    local affinity=$(timeout 20 find / -name fusioncube_Irq_Affinity.sh; echo $?)
    if [[ $affinity =~ 124 ]]; then
        resultCode=1
        errorKey="${checkItemId}0001"
        log ERROR "FSA_${checkItemId}:unok"
        originalInfo="${originalInfo}""command:find / -name fusioncube_Irq_Affinity.sh timeout"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi
    originalInfo="${originalInfo}""command:lsattr \$(find / -name fusioncube_Irq_Affinity.sh) \n"
    originalInfo="${originalInfo}""result:${affinity}\n"

    for aff in ${affinity[@]}
    do
        if [[ "$aff" = "1" ]] || [[ "$aff" = "0" ]]; then
            continue
        fi
        local res=`lsattr ${aff}  | awk '{print $1}'`
        originalInfo="${originalInfo}""result:${res}\n"
        if  [ "${res}" == "----i--------" ]; then
            resultCode=1
            errorKey="${checkItemId}0001"
            log ERROR "The file permission is incorrect."
            log ERROR "FSA_${checkItemId}:unok"
            FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
            return 1
        fi
    done

    log INFO "FSA_${checkItemId}:ok"
    FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
    return 0
}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}