#!/bin/bash

#############################################################
#
# 检查CSSD能容忍不能访问Voting Disks的时间
# 错误码：
#         0000 正常
#         0001 不正常
#
#############################################################

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"
PATH="/sbin:/usr/sbin:/usr/local/sbin:/root/bin:/usr/local/bin:/usr/bin:/bin:/opt/omm/oma/workspace/tools"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }

checkItemId="1212"
resultCode=0
errorKey=""
params=""
originalInfo=""

function main()
{
    agent_items_check ${checkItemId}
    if [ $? -ne 0 ]
    then
       log INFO "${checkItemId} do not select, pass"
       return 0
    fi

    if [[ ! -f "/opt/fc2/cfg/server_info.conf" ]]
    then
        log INFO "FSA_${checkItemId}:unok"
        resultCode=1
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi

    local scenario=`cat /opt/fc2/cfg/server_info.conf | grep scenario |awk -F = '{print $2}'`
    if [ $scenario != "DBaSS" ];then
        log INFO "FSA_${checkItemId}:ok"
        originalInfo="${originalInfo}""Not involved in the current scenario."
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

    local nodeType=$(cat /opt/fc2/cfg/server_info.conf | grep "nodeType" | awk -F '=' '{print $2}')
    if  [ "${nodeType}" != "DBN" ]; then
        log INFO "FSA_${checkItemId}:ok"
        errorKey="${checkItemId}0002"
        originalInfo="${originalInfo}""The current node is not involved."
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

    if [ ! -d "/home/grid" ]; then
      # 判断安装了ORACLE
        log INFO "FSA_${checkItemId}:ok"
        originalInfo="${originalInfo}""The current node is not involved."
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

    local gridHome=$(timeout 20 find /u01/ -name crsctl; echo $?)
    if [[ $gridHome =~ 124 ]]; then
        resultCode=1
        log ERROR "FSA_${checkItemId}:unok"
        originalInfo="${originalInfo}""command:find /u01/ -name crsctl timeout"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi
    for aff in ${gridHome[@]}
    do
      if [[ "$aff" = "1" ]] || [[ "$aff" = "0" ]]; then
        continue
      fi
      local disktimeout=$(${aff} get css disktimeout | awk '{print $5}')
      echo $disktimeout | grep -q '[^0-9]'
      not_exist=$?
      originalInfo="${originalInfo}""command:crsctl get css disktimeout \n"
      originalInfo="${originalInfo}""result:${disktimeout} \n"
      if [[ ! -z ${not_exist} ]] && [ $disktimeout -ge 200 ] 2>/dev/null; then
          log INFO "FSA_${checkItemId}:ok"
          FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
          return 0
      fi
    done

    resultCode=1
    log ERROR "FSA_${checkItemId}:unok"
    FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
    return 1
}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}