#!/bin/bash

#############################################################
#
# 检查Oracle ASM心跳超时时间
# 错误码：
#         0000 正常
#         0001 不正常
#
#############################################################

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }

checkItemId="1213"
resultCode=0
errorKey=""
params=""
originalInfo=""

function main()
{
    agent_items_check ${checkItemId}
    if [ $? -ne 0 ]
    then
       log INFO "${checkItemId} do not select, pass"
       return 0
    fi

    if [[ ! -f "/opt/fc2/cfg/server_info.conf" ]]
    then
        log INFO "FSA_${checkItemId}:unok"
        resultCode=1
        originalInfo="${originalInfo}""result:/opt/fc2/cfg/server_info.conf is not exist.\n"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi

    local scenario=`cat /opt/fc2/cfg/server_info.conf | grep scenario |awk -F = '{print $2}'`
    if [ $scenario != "DBaSS" ];then
        log INFO "FSA_${checkItemId}:ok"
        originalInfo="${originalInfo}""Not involved in the current scenario."
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

    local nodeType=$(cat /opt/fc2/cfg/server_info.conf | grep "nodeType" | awk -F '=' '{print $2}')
    if  [ "${nodeType}" != "DBN" ]; then
        log INFO "FSA_${checkItemId}:ok"
        errorKey="${checkItemId}0002"
        originalInfo="${originalInfo}""The current node is not involved."
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

    if [ ! -d "/home/grid" ]; then
      # 判断安装了ORACLE
        log INFO "FSA_${checkItemId}:ok"
        originalInfo="${originalInfo}""The current node is not involved."
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

    local asmHbeatiowait=$(su - grid -c "
 sqlplus -S /nolog << EOF 2>&1
 connect sqlplus / as sysasm
 spool /tmp/grid_dept.lst
 set linesize 100 pagesize 80
select ksppinm,ksppstvl,ksppdesc from x\\\$ksppi x,x\\\$ksppcv y where x.indx = y.indx and ksppinm='_asm_hbeatiowait';
spool off;
 exit;
EOF
exit"
)

    local asmnum=$(echo ${asmHbeatiowait} | awk -F _asm_hbeatiowait '{print $2}' | awk '{print $1}')
    originalInfo="${originalInfo}""asm_hbeatiowait:${asmnum} \n"
    echo $asmnum | grep -q '[^0-9]'
    not_exist=$?
    if [[ ! -z ${not_exist} ]] && [ $asmnum -ge 120 ] 2>/dev/null; then
        log INFO "FSA_${checkItemId}:ok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

    resultCode=1
    log INFO "FSA_${checkItemId}:unok"
    FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
    return 1
}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}