#!/bin/bash

#############################################################
#
# 如果数据库节点挂载了FusionStorage卷做为文件系统，检查hang返回时间
# 错误码：
#         0000 正常
#         0001 不正常
#
#############################################################

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }

checkItemId="1216"
resultCode=0
errorKey=""
params=""
originalInfo=""


function main()
{
    agent_items_check ${checkItemId}
    if [ $? -ne 0 ]
    then
       log INFO "${checkItemId} do not select, pass"
       return 0
    fi

    if [[ ! -f "/opt/fc2/cfg/server_info.conf" ]]
    then
        log INFO "FSA_${checkItemId}:unok"
        resultCode=1
        originalInfo="${originalInfo}""result:/opt/fc2/cfg/server_info.conf is not exist.\n"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi

    local nodeType=$(cat /opt/fc2/cfg/server_info.conf | grep "nodeType" | awk -F '=' '{print $2}')
    if  [ "${nodeType}" != "DBN" ]; then
        log INFO "FSA_${checkItemId}:ok"
        errorKey="${checkItemId}0002"
        originalInfo="${originalInfo}""The current node is not involved."
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

    local hang=`cat /opt/dsware/vbs/conf/vbs_*_conf.cfg | grep g_dsware_io_hang_timeout | tr -cd "[0-9]"`
    originalInfo="${originalInfo}""command:cat /opt/dsware/vbs/conf/vbs_*_conf.cfg | grep g_dsware_io_hang_timeout \n"
    originalInfo="${originalInfo}""result:${hang} \n"

    if [[ ! -z ${hang} ]] && [ "${hang}" -ne 120 ] 2>/dev/null; then
        resultCode=1
        log INFO "FSA_${checkItemId}:unok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi

    log INFO "FSA_${checkItemId}:ok"
    FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
    return 0
}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}