#!/bin/bash

#############################################################
#
# 检查是否存在第三方GPU驱动
# 错误码：
#         0000 正常
#         0001 不正常
#
#############################################################

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }

checkItemId="1217"
resultCode=0
errorKey=""
params=""
originalInfo=""


function main()
{
    agent_items_check ${checkItemId}
    if [ $? -ne 0 ]
    then
       log INFO "${checkItemId} do not select, pass"
       return 0
    fi

    if [[ ! -f "/opt/fc2/cfg/server_info.conf" ]]
    then
        log INFO "FSA_${checkItemId}:unok"
        resultCode=1
        originalInfo="${originalInfo}""result:/opt/fc2/cfg/server_info.conf is not exist.\n"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi

    local scenario=`cat /opt/fc2/cfg/server_info.conf | grep scenario |awk -F = '{print $2}'`
    if [ $scenario != "FusionsphereIaSS" ];then
        log INFO "FSA_${checkItemId}:ok"
        originalInfo="${originalInfo}""Not involved in the current scenario."
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

    local nodeType=$(cat /opt/fc2/cfg/server_info.conf | grep "nodeType" | awk -F '=' '{print $2}')
    if  [ "${nodeType}" != "CNA" ]; then
        log INFO "FSA_${checkItemId}:ok"
        errorKey="${checkItemId}0002"
        originalInfo="${originalInfo}""The current node is not involved."
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

    local nvidia=`lspci | grep -i nvidia`
    originalInfo="${originalInfo}""command:lspci | grep -i nvidia \n"
    originalInfo="${originalInfo}""result:${nvidia} \n"

    if [ -z "${nvidia}" ]; then
         resultCode=0
        log INFO "FSA_${checkItemId}:ok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

    resultCode=1
    log INFO "FSA_${checkItemId}:unok"
    FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
    return 1
}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}