#!/bin/bash
#检查IB驱动固件版本

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"
PATH="/sbin:/usr/sbin:/usr/local/sbin:/root/bin:/usr/local/bin:/usr/bin:/bin:/opt/omm/oma/workspace/tools"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }

checkItemId="1220"
resultCode=0
errorKey=""
params=""
originalInfo=""

#脚本入参，节点类型
NODE_TYPE=$1

function main()
{
    agent_items_check ${checkItemId}
    if [ $? -ne 0 ]
    then
        log INFO "${checkItemId} do not select, pass"
        return 0
    else
        check_main
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
    fi
    return ${resultCode}
}

function check_main()
{
    local network_port_ib=$(ibdev2netdev 2>/dev/null | grep Up | awk -F '==>' '{print $2}' | awk  '{print $1}')
    originalInfo="${originalInfo}""command:ibdev2netdev\n"
    originalInfo="${originalInfo}""result:${network_port_ib}\n"
    if [[ -z ${network_port_ib} ]];then
        resultCode=0
        errorKey="${checkItemId}0001"   # 无IB网口或未启用IB网卡
        log ERROR "no network_port_ib or unused network_port_ib."
        log ERROR "FSA_${checkItemId}:unok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

    local firmware_version=$(ethtool -i ib0 2>/dev/null | grep -w firmware-version)
    local driver_version=$(ethtool -i ib0 2>/dev/null | grep -w "^version")
    originalInfo="${originalInfo}""command:ethtool -i ib0 | grep -w firmware-version\n"
    originalInfo="${originalInfo}""result:${firmware_version}\n"
    originalInfo="${originalInfo}""command:ethtool -i ib0 | grep -w ^version\n"
    originalInfo="${originalInfo}""result:${driver_version}\n"

    local firmware_version_num=$(ethtool -i ib0 2>/dev/null | grep -w firmware-version | tr -cd "[0-9]")
    local driver_version_num=$(ethtool -i ib0 2>/dev/null | grep -w "^version" | tr -cd "[0-9]")
    if [[ ${firmware_version_num} -ne 2425000 || ${driver_version_num:0:1} -lt 3 ]];then
        resultCode=1
        errorKey="${checkItemId}0002"   # 驱动或固件版本不支持
        log ERROR "no network_port_ib or unused network_port_ib."
        log ERROR "FSA_${checkItemId}:unok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi

    resultCode=0
    log INFO "FSA_${checkItemId}:ok"
    FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
    return ${resultCode}
}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}

##############################
#
#
#  检查IB驱动固件版本
#  0001 无IB网口或未启用IB网卡
#  0002 驱动或固件版本不符合基线要求
#
#
##############################