#!/bin/bash
#检查message日志

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"
PATH="/sbin:/usr/sbin:/usr/local/sbin:/root/bin:/usr/local/bin:/usr/bin:/bin:/opt/omm/oma/workspace/tools"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }

checkItemId="1221"
resultCode=0
errorKey=""
params=""
originalInfo=""

#脚本入参，节点类型
NODE_TYPE=$1

function main()
{
    agent_items_check ${checkItemId}
    if [ $? -ne 0 ]
    then
        log INFO "${checkItemId} do not select, pass"
        return 0
    else
        check_main
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
    fi
    return ${resultCode}
}

function check_main()
{
    local network_port_ib=$(ibdev2netdev 2>/dev/null | grep Up | awk -F '==>' '{print $2}' | awk  '{print $1}')
    originalInfo="${originalInfo}""command:ibdev2netdev\n"
    originalInfo="${originalInfo}""result:${network_port_ib}\n"
    if [[ -z ${network_port_ib} ]];then
        resultCode=0
        errorKey="${checkItemId}0001"   # 无IB网口或未启用IB网卡
        log ERROR "no network_port_ib or unused network_port_ib."
        log ERROR "FSA_${checkItemId}:unok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

    local ib_internal_error=$(dmesg -T | grep "Internal error detected")
    originalInfo="${originalInfo}""command:dmesg -T | grep 'Internal error detected'\n"
    originalInfo="${originalInfo}""result:${ib_internal_error}\n"
    if [[ ! -z ${ib_internal_error} ]];then
        resultCode=1
        errorKey="${checkItemId}0002"   # IB网络异常
        log ERROR "The IB network is abnormal."
        log ERROR "FSA_${checkItemId}:unok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi

    resultCode=0
    log INFO "FSA_${checkItemId}:ok"
    FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
    return ${resultCode}

}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}

##############################
#
#
#  检查message日志
#
#
##############################