#!/bin/bash

PATH="/sbin:/usr/sbin:/usr/local/sbin:/root/bin:/usr/local/bin:/usr/bin:/bin:/opt/omm/oma/workspace/tools"

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"
source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }

updaCfg="/opt/omm/oma/workspace/conf/upda.cfg"
ip=$(cat $updaCfg | grep "LOCALIP=" | awk -F '=' '{print $2}')

function output()
{
   echo "$1"":" >>$LOG_DIR
   echo >>$LOG_DIR
   tmp="$1"
   eval echo \"\$${tmp}\" >>$LOG_DIR
   echo "---------------------------------------------------------------">>$LOG_DIR
}

function collect_node_type()
{
    local agentMonitor="/opt/dsware/agent/conf/agentMonitor"
    vbs_judg=`cat $agentMonitor | grep vbs|grep -v alarm | grep -E "True" | wc -l`
    osd_judg=`cat $agentMonitor | grep osd|grep -v alarm | grep -E "True" | wc -l`

    if [ $vbs_judg -ne 0 ] && [ $osd_judg -eq 0 ]
    then
        node_type="Only VBS node "
        LOG_DIR="/var/log/dsware/FSA_vbs_${ip}_upgrade_precheck_collect.txt"

    elif [ $vbs_judg -eq 0 ] && [ $osd_judg -ne 0 ]
    then
        node_type="Only OSD node"
        id=`cat /opt/dsware/osd/conf/osd_*conf.cfg |grep poolid|awk -F '=' '{print $2}'`
        if [ -z "${id}" ]
        then
            id=0
        fi
        LOG_DIR="/var/log/dsware/FSA_osd_${id}_${ip}_upgrade_precheck_collect.txt"
    elif [ $vbs_judg -ne 0 ] && [ $osd_judg -ne 0 ]
    then
        node_type="Both VBS and OSD node"
        id=`cat /opt/dsware/osd/conf/osd_*conf.cfg |grep poolid|awk -F '=' '{print $2}'`
        if [ -z "${id}" ]
        then
            id=0
        fi
        LOG_DIR="/var/log/dsware/FSA_osd_${id}_vbs_${ip}_upgrade_precheck_collect.txt"
    elif [ $vbs_judg -eq 0 ] && [ $osd_judg -eq 0 ]
    then
        node_type="Neither VBS or OSD node"
        LOG_DIR="/var/log/dsware/FSA_${ip}_upgrade_precheck_collect.txt"
    fi

    if [ -a $LOG_DIR ]
    then
        echo > $LOG_DIR
    else
        touch $LOG_DIR
    fi
    chmod 666 $LOG_DIR

    VBS_num=`ps -ef |grep dsware_vbs| grep -v grep -c`
    OSD_num=`ps -ef |grep dsware_osd| grep -v grep -c`

    output node_type
    output VBS_num
    output OSD_num
}


function collect_OS_kernel()
{
    OS_type=`cat /etc/*-release`
    OS_kernel=`uname -r`
    output OS_type
    output OS_kernel
}

function collect_node_info()
{
    Server_type=`dmidecode|grep "System Information" -A9|egrep  "Manufacturer|Product"`
    Cpu_type=`cat /proc/cpuinfo | grep name | cut -f2 -d: | uniq -c`
    Smio_host=`cat /proc/smio_host`
    RaidCard_type=`lspci |grep -i lsi`
    Ethernet_type=`lspci |grep -i Ethernet`
    Net_Type=`cat /opt/dsware/agent/conf/network.cfg |grep -i network_type|awk -F '=' '{print $2}'`
    if [[ $Net_Type =~ "InfiniBand" ]]
    then
        port=`ibdev2netdev |grep -i up|head -1|awk -F '>' '{print $2}'|awk -F '(' '{print $1}'`
        port_driver=`ethtool -i $port`
    fi
    output Server_type
    output Cpu_type
    output Smio_host
    output RaidCard_type
    output Ethernet_type
    output Net_Type
    if [ ! -z "${port_driver}" ]
    then
        output port_driver
    fi
}



function collect_solution_type()
{
    if [ -e /etc/hostos.version ]
    then
        OpenStack=`cat /etc/hostos.version`
        output OpenStack
    fi

    if [ -e /opt/galax/version/GalaxVersion.cfg ]
    then
        FusionCompute=`cat /opt/galax/version/GalaxVersion.cfg`
        output FusionCompute
    fi
}

function main()
{
    collect_node_type
    collect_OS_kernel
    collect_node_info
    collect_solution_type
}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}