#!/bin/bash

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/error.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/error.sh failed."; exit 130; }

function main()
{
    rm -rf /opt/dsware/update/work/Precheck

    flag="0"

    # 还原备份的框架lua
    if [[ -f /opt/omm/oma/flow/default/upd_atoms.lua.bak ]]
    then
        log INFO "Restoring file: /opt/omm/oma/flow/default/upd_atoms.lua"
        mv -f /opt/omm/oma/flow/default/upd_atoms.lua.bak /opt/omm/oma/flow/default/upd_atoms.lua || { log ERROR "Restores /opt/omm/oma/flow/default/upd_atoms.lua failed.";flag="1";}
    fi

    if [[ -f /opt/omm/oma/flow/upd_atoms.lua.bak ]]
    then
        log INFO "Restoring file: /opt/omm/oma/flow/upd_atoms.lua"
        mv -f /opt/omm/oma/flow/upd_atoms.lua.bak /opt/omm/oma/flow/upd_atoms.lua || { log ERROR "Restores /opt/omm/oma/flow/upd_atoms.lua failed.";flag="1";}
    fi

    if [[ -f /opt/dsware/agent/tool/pmi/infoCollect/Collect_match.sh.bak ]]
    then
        log INFO "Restoring file: /opt/dsware/agent/tool/pmi/infoCollect/Collect_match.sh"
        mv -f /opt/dsware/agent/tool/pmi/infoCollect/Collect_match.sh.bak /opt/dsware/agent/tool/pmi/infoCollect/Collect_match.sh || { log ERROR "Restores Collect_match.sh failed.";}
    fi

    return "${flag}"
}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}
