#!/bin/bash

cd $(dirname $0)
g_curPath="$PWD"
g_scriptName="$(basename $0)"
cd - >> /dev/null

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }

#输出到json文件中的checkItemId,每个检查脚本一个id
checkItemId="22"
resultCode=0
errorKey=""
params=""
originalInfo=""

upda_cfg="/opt/omm/oma/workspace/conf/upda.cfg"
node_mananger_ip_file="/etc/node_manager_ip"
dsware_mananger_ip_file="/opt/dsware/agent/conf/dsware_manager_ip"


function check_main()
{
    if [ -f "${node_mananger_ip_file}" ]
    then
        node_mananger_ip=$(cat ${node_mananger_ip_file} | grep "node_manager_ip=" | awk -F '=' '{print $2}')
        originalInfo="cat ${node_mananger_ip_file} | grep node_manager_ip= | awk -F '=' '{print \$2}'\n""${node_mananger_ip}\n"

        local_ip=$(cat ${upda_cfg} | grep  "LOCALIP=" | awk -F '=' '{print $2}')
        originalInfo="${originalInfo}""cat ${upda_cfg} | grep LOCALIP= | awk -F '=' '{print \$2}'\n""${local_ip}\n"

        if [ "${node_mananger_ip}" != "${local_ip}" ]
        then
            log ERROR "node_mananger_ip=${node_mananger_ip} not equals LOCALIP=${local_ip}"
            resultCode=1
            errorKey="220001"
        fi
    fi

    if [ -f "${dsware_mananger_ip_file}" ]
    then
        dsware_mananger_ip=$(cat ${dsware_mananger_ip_file} | grep "dsware_manager_ip="| awk -F '=' '{print $2}')
        originalInfo="${originalInfo}""cat ${dsware_mananger_ip_file} | grep dsware_manager_ip=| awk -F '=' '{print \$2}'\n""${dsware_mananger_ip}\n"

        float_ip=$(cat ${upda_cfg} | grep "SERVERIP=" | awk -F '=' '{print $2}')
        originalInfo="${originalInfo}""cat ${upda_cfg} | grep SERVERIP= | awk -F '=' '{print \$2}'\n""${float_ip}\n"

        if [ "${dsware_mananger_ip}" != "${float_ip}" ]
        then
            log EROROR "dsware_mananger_ip=${dsware_mananger_ip} not equals SERVERIP=${float_ip}"
            resultCode=1
            if [[ -z "${errorKey}" ]]
            then
                errorKey="220002"
            else
                errorKey="220003"
            fi
        fi
    fi
    return 0
}

function main()
{
    check_main
    FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
    return "${resultCode}"
}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}