#!/bin/bash

cd $(dirname $0)
g_curPath="$PWD"
g_scriptName="$(basename $0)"
cd - >> /dev/null

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }

#输出到json文件中的checkItemId,每个检查脚本一个id
checkItemId="21"
resultCode=0
errorKey=""
params=""
originalInfo=""

dsware_agent_check_command="sh /opt/dsware/agent/script/dswareAgent_tool.sh status"

function check_main()
{
    local info=""
    for temp in {1..5}
    do
        info=$(${dsware_agent_check_command})

        if [[ "${info}" == "result=0" ]]
        then
            log INFO "check dsware_agent process successfully. check:${info}"
            originalInfo="${dsware_agent_check_command}""\n${info}"
            return 0
        fi
        log ERROR "check dsware_agent process abnormal: ${info}. check count=${temp}"
        sleep 2
    done

    resultCode=1
    errorKey="210001"
    originalInfo="${dsware_agent_check_command}""\n${info}"
    return 1
}

function main()
{
    check_main
    FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
    return "${resultCode}"
}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}