#!/bin/bash

cd $(dirname $0)
g_curPath="$PWD"
g_scriptName="$(basename $0)"
cd - >> /dev/null

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }

#输出到json文件中的checkItemId,每个检查脚本一个id
checkItemId="20"
resultCode=0
errorKey=""
params=""
originalInfo=""

function check_main()
{
    #如果有10个以上进程进入D Z状态，则返回失败
    local d_process_count=$(ps -e -o stat | grep -v grep | grep -E "D" | wc -l)

    if [ "${d_process_count}" -gt "10" ]; then
        log ERROR "process status error: exist more than 10 D status process ,d_process_count=[${d_process_count}]."
        resultCode=1
        errorKey="200001"
    fi

    local z_process_count=$(ps -e -o stat | grep -v grep | grep -E "Z" | wc -l)
    if [ "${z_process_count}" -gt "10" ]; then
        log ERROR "process status error: exist more than 10 Z status process ,z_process_count=[${z_process_count}]."
        resultCode=1
        errorKey="200001"
    fi
    log INFO "D status process num:${d_process_count}, Z status process num:${z_process_count}"

    originalInfo="command:ps -e -o stat | grep -v grep | grep -E D | wc -l""\n${d_process_count}\n""command:ps -e -o stat | grep -v grep | grep -E Z | wc -l""\n${z_process_count}"
    return 0
}

function main()
{
    check_main
    FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
    return "${resultCode}"
}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}