#!/bin/bash

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }

checkItemId="41"
resultCode=0
errorKey=""
params=""
originalInfo=""

main()
{

    local version=`cat /opt/dsware/DSwareAgentNodeVersion|grep nodeVersion|awk -F '=' '{print $2}'`
    originalInfo="command:cat /opt/dsware/DSwareAgentNodeVersion|grep nodeVersion|awk -F '=' '{print \$2}'\n"
    originalInfo="${originalInfo}""review:nodeVersion=${version}\n"
    if [[ ! $version =~ "V100R003C30U2" ]]
    then
        originalInfo="${originalInfo}""result:nodeVersion is not belong to V100R003C30U2."
        log INFO "${checkItemId}FSA_check_JBOD:nodeVersion is not belong to V100R003C30U2."
        log INFO "${checkItemId}:FSA_check_JBOD:ok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

    if [ ! -f "/opt/MegaRAID/MegaCli/MegaCli64" -a ! -f "/opt/MegaRAID/storcli/storcli64" ]
    then
        originalInfo="${originalInfo}""command:[ ! -f /opt/MegaRAID/MegaCli/MegaCli64 -a ! -f /opt/MegaRAID/storcli/storcli64 ]\n"
        originalInfo="${originalInfo}""review:file is not found.\n"
        originalInfo="${originalInfo}""result:FSA_check_JBOD:this server do not have /opt/MegaRAID/MegaCli/MegaCli64 and /opt/MegaRAID/storcli/storcli64."
        log INFO "${checkItemId}FSA_check_JBOD:this server do not have /opt/MegaRAID/MegaCli/MegaCli64 and /opt/MegaRAID/storcli/storcli64."
        log INFO "${checkItemId}:FSA_check_JBOD:ok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

    JBOD_status=`/opt/MegaRAID/MegaCli/MegaCli64 -AdpGetProp -EnableJBOD -aALL | grep -i jbod | grep -i "enabled"`    
    originalInfo="${originalInfo}""command:/opt/MegaRAID/MegaCli/MegaCli64 -AdpGetProp -EnableJBOD -aALL | grep -i jbod | grep -i enabled\n"
    originalInfo="${originalInfo}""result:${originalInfo}\n"
    raid0_1=`/opt/MegaRAID/storcli/storcli64 /c0 show |grep -i RAID0`
    originalInfo="${originalInfo}""command:/opt/MegaRAID/storcli/storcli64 /c0 show |grep -i RAID0\n"
    originalInfo="${originalInfo}""review:${raid0_1}\n"
    raid0_2=`/opt/MegaRAID/MegaCli/MegaCli64 /c0 show |grep -i RAID0`
    originalInfo="${originalInfo}""command:/opt/MegaRAID/MegaCli/MegaCli64 /c0 show |grep -i RAID0\n"
    originalInfo="${originalInfo}""review:${raid0_2}\n"
    if [[ -z ${JBOD_status} ]]
    then
        originalInfo="${originalInfo}""result:this server not run JBOD server."
        log INFO "${checkItemId}FSA_check_JBOD:this server not run JBOD server."
        log INFO "${checkItemId}:FSA_check_JBOD:ok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    else
        if [[ -n "${raid0_1}" || -n "${raid0_2}" ]]
        then 
            resultCode=1
            errorKey="${checkItemId}0001"  #  0001  主机系统开启了 JBOD 和raid0 两种服务模式
            originalInfo="${originalInfo}""result:this server have JBOD server and raid0 server at the same time."
            log ERROR "${checkItemId}FSA_check_JBOD:this server have JBOD server and raid0 server at the same time."
            log ERROR "${checkItemId}:FSA_check_JBOD:unok"
            FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
            return 1
        else
            originalInfo="${originalInfo}""result:this server have JBOD server but do not run raid0 server."
            log INFO "${checkItemId}FSA_check_JBOD:this server have JBOD server but do not run raid0 server."
            log INFO "${checkItemId}:FSA_check_JBOD:ok"
            FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
            return 0
        fi
    fi

}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}

##############################
#
#  错误码：
#  0001 主机系统开启了 JBOD 和raid0 两种服务模式
#
##############################