#!/bin/bash

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }

checkItemId="69"
resultCode=0
errorKey=""
params=""
originalInfo=""

#V100R006C30SPH505升级到V100R006C30SPH506，存储节点为uvp系统，会升级失败

function main()
{
    src_version="$(get_src_version)"
    if [[ ! ${src_version} == V100R006C30SPH505 ]]
    then
        #pass
        originalInfo="command:get src_version\n"
        originalInfo="${originalInfo}""review:src_version is ${src_version}\n"
        originalInfo="${originalInfo}""result:src_version not belong to V100R006C30SPH505."
        log INFO "${checkItemId}:FSA_check_UVP.sh:src_version not belong to V100R006C30SPH505."
        log INFO "${checkItemId}:FSA_check_UVP.sh:ok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi
    
    target_version="$(get_package_version)"
    if [[ ! ${target_version} == V100R006C30SPH506 ]]
    then
        #pass
        originalInfo="command:get target_version\n"
        originalInfo="${originalInfo}""review:target_version is ${target_version}\n"
        originalInfo="${originalInfo}""result:target_version not belong to V100R006C30SPH506."
        log INFO "${checkItemId}:FSA_check_UVP.sh:target_version not belong to V100R006C30SPH506."
        log INFO "${checkItemId}:FSA_check_UVP.sh:ok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

    local agentMonitor="/opt/dsware/agent/conf/agentMonitor"
    #有监控OSD，认为是存储节点
    isStorageNode=$(cat $agentMonitor | grep osd)
    if [ -z ${isStorageNode} ]
    then
        #不为存储节点
        originalInfo="command:cat ${agentMonitor} | grep osd\n"
        originalInfo="${originalInfo}""review:isStorageNode is false\n"
        originalInfo="${originalInfo}""result:This Node is not storage node."
        log INFO "${checkItemId}:FSA_check_UVP.sh:This Node is not storage node."
        log INFO "${checkItemId}:FSA_check_UVP.sh:ok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi
    
    if [ ! -f "/etc/uvp_version" ]
    then
        #文件不存在，为非UVP系统，
        originalInfo="command:check whether the /etc/uvp_version file exists.\n"
        originalInfo="${originalInfo}""review:isStorageNode is false\n"
        originalInfo="${originalInfo}""result:/etc/uvp_version file not exists."
        log INFO "${checkItemId}:FSA_check_UVP.sh:System Version is not UVP."
        log INFO "${checkItemId}:FSA_check_UVP.sh:ok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi
    
    #UVP 系统，报错
    originalInfo="review:src_version is ${src_version}\n"
    originalInfo="${originalInfo}""review:target_version is ${target_version}\n"
    originalInfo="${originalInfo}""review:isStorageNode is true\n"
    originalInfo="${originalInfo}""review:/etc/uvp_version file exists.\n"
    originalInfo="${originalInfo}""result:There is ERROR UPV System OS."
    
    log ERROR "${originalInfo}"
    resultCode=1
    errorKey="${checkItemId}0001"
    FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
    
    return 1
}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}

##############################
#
#  错误码：
#  690001 /opt/dsware/agent/script/MegaSAS.log文件存在，但是已经进行日志转储
#
##############################