#!/bin/bash

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }

checkItemId="40"
resultCode=0
errorKey=""
params=""
originalInfo=""

main()
{

    local dsware6_version=`cat /opt/dsware/DSwareAgentNodeVersion|grep nodeVersion|awk -F '=' '{print $2}'`
    originalInfo="command:cat /opt/dsware/DSwareAgentNodeVersion|grep nodeVersion|awk -F '=' '{print \$2}'\n"
    originalInfo="${originalInfo}""review:${dsware6_version}\n"

    if [[ $dsware6_version =~ "V100R003C02" || $dsware6_version =~ "V100R003C30U1" ]]
    then
        local num_review=`lspci | grep 19e5 | egrep -o 0123 -c`
        #上命令返回值中有0123字符，则使用了V3 SSD卡，判断为unok
        originalInfo="${originalInfo}""command:lspci | grep 19e5 | egrep -o 0123 -c\n"
        originalInfo="${originalInfo}""review:${num_review}\n"
        if [ $num_review -ne 0 ]
        then
            resultCode=1
            errorKey="${checkItemId}0001"    #  0001  特定版本使用了 V3 SSDcard
            originalInfo="${originalInfo}""result:web server's version is $dsware6_version , and web server have V3 SSD card."
            log ERROR "${checkItemId}FSA_check_V3_SSDcard.sh:web server's version is $dsware6_version , and web server have V3 SSD card."
            log ERROR "${checkItemId}:FSA_check_V3_SSDcard.sh:unok"
            FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
            return 1
        else
            originalInfo="${originalInfo}""result:FSA  check V3 SSDcard:ok"
            log INFO "${checkItemId}:FSA_check_V3_SSDcard:ok"
            FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
            return 0
        fi
    else
        originalInfo="${originalInfo}""result:DSwareAgentNodeVersion not belong to 'V100R003C02' or 'V100R003C30U1'"
        log INFO "${checkItemId}FSA_check_V3_SSDcard:DSwareAgentNodeVersion not belong to 'V100R003C02' or 'V100R003C30U1'"
        log INFO "${checkItemId}:FSA_check_V3_SSDcard:ok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}

##############################
#
#  错误码：
#  0001 特定版本使用了 V3 SSDcard
#
##############################