#!/bin/bash

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }

checkItemId="50"
resultCode=0
errorKey=""
params=""
originalInfo=""

main()
{
    update_version=$(get_package_version)
    local user=`id fsp 2>&1`
    originalInfo="command:id fsp\n"
    originalInfo="${originalInfo}""review:${user}\n"

    id fsp >/dev/null 2>&1
    if [ $? -ne 0 ]
    then
        originalInfo="${originalInfo}""No fsp user,no need to check\n"
        resultCode=0
        log INFO "${checkItemId}:No fsp user,FSA_check_blockstorage.sh:ok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

    rpm_file="$(rpm -qa | grep FusionStorageAgent | wc -l)"
    originalInfo="${originalInfo}""command:rpm -qa | grep FusionStorageAgent | wc -l\n"
    originalInfo="${originalInfo}""review:${rpm_file}\n"
    if [ ${rpm_file} -eq 0 ]
    then
        resultCode=1
        errorKey="${checkItemId}0001"    #  0001 此 OpenStack 节点没有配置安装 blockstorage
        originalInfo="${originalInfo}""result:This OpenStack node not install blockstorage"
        log ERROR "${checkItemId}FSA_check_blockstorage.sh:This OpenStack node not install blockstorage."
        log ERROR "${checkItemId}:FSA_check_blockstorage.sh:unok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi

    ##内存不精确计算，按照VBS一个8G，OSD一个3G，MDC（ZK）一个5G进行计算
    local Need_Memory=0
    local agentMonitor="/opt/dsware/agent/conf/agentMonitor"
    vbs_judg=`cat $agentMonitor | grep vbs|grep -v alarm | grep -E "True" | wc -l`
    osd_judg=`cat $agentMonitor | grep osd|grep -v alarm | grep -E "True" | wc -l`
    mdc_judg=`cat $agentMonitor | grep mdc|grep -v alarm | grep -E "True" | wc -l`

    if [[ ${update_version} =~ "V100R006C30" ]]
    then
        Need_Memory=`expr $[$vbs_judg*6] + $[$osd_judg*3] + $[$mdc_judg*4]`
    else
        Need_Memory=`expr $[$vbs_judg*8] + $[$osd_judg*3] + $[$mdc_judg*5]`
    fi
    log INFO "${checkItemId}:vbs_judg=${vbs_judg},osd_judg=${osd_judg},mdc_judg=${mdc_judg};All need_memory is ${Need_Memory}G"
    originalInfo="${originalInfo}""vbs_judg=${vbs_judg},osd_judg=${osd_judg},mdc_judg=${mdc_judg};All need_memory is ${Need_Memory}G\n"

    local memory_limit_file="/sys/fs/cgroup/memory/system.slice/fsp/blockstorage/memory.limit_in_bytes"
    if [ ! -f ${memory_limit_file} ]
    then
        log ERROR "${checkItemId}:/sys/fs/cgroup/memory/system.slice/fsp/blockstorage/memory.limit_in_bytes not exist!"
        originalInfo="${originalInfo}""/sys/fs/cgroup/memory/system.slice/fsp/blockstorage/memory.limit_in_bytes not exist!\n"
        resultCode=1
        errorKey="${checkItemId}0003"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi
    local Alloc_Memory_tmp=`cat ${memory_limit_file} | sed 's/ //g'`
    Alloc_Memory=`awk 'BEGIN{printf "%.2f\n",'$Alloc_Memory_tmp'/1024/1024/1024}'`
    log INFO "${checkItemId}:Alloc_Memory is ${Alloc_Memory}G"
    originalInfo="${originalInfo}""Alloc_Memory is ${Alloc_Memory}G\n"

    if [ `expr $Alloc_Memory \< $Need_Memory` -eq 1 ]
    then
        log ERROR "${checkItemId}:Alloc_Memory is not enough!"
        resultCode=1
        errorKey="${checkItemId}0002"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi

    originalInfo="${originalInfo}""result:FSA check blockstorage and alloc_memory:ok"
    log INFO "${checkItemId}:FSA_check_blockstorage.sh:ok"
    FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
    return 0

}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}

##############################
#
#  错误码：
#  0001 此OpenStack节点没有配置安装blockstorage
#  0002 配置了blockstorage角色，但是预留资源不足
#  0003 /sys/fs/cgroup/memory/system.slice/fsp/blockstorage/memory.limit_in_bytes文件不存在
##############################