#!/bin/bash
PATH="/sbin:/usr/sbin:/usr/local/sbin:/root/bin:/usr/local/bin:/usr/bin:/bin:/opt/omm/oma/workspace/tools"

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }

checkItemId="31"
resultCode=0
errorKey=""
params=""
originalInfo=""

main()
{

    error_status=0

    chkconfig --list >/dev/null 2>&1
    if [ $? -ne 0 ]
    then
        error_status=1
        error_commands="chkconfig --list ,"
        log ERROR "${checkItemId}FSA_check_chkconfig_info.sh:Command of 'chkconfig --list' execution failed"
    fi


    service --help >/dev/null 2>&1
    if [ $? -ne 0 ]
    then
        error_status=1
        error_commands="${error_commands}""service --help ,"
        log ERROR "${checkItemId}FSA_check_chkconfig_info.sh:Command of 'service --help' execution failed"
    fi


    ln --help >/dev/null 2>&1
    if [ $? -ne 0 ]
    then
        error_status=1
        error_commands="${error_commands}""ln --help ,"
        log ERROR "${checkItemId}FSA_check_chkconfig_info.sh:Command of 'ln --help' execution failed"
    fi


    ldconfig --help >/dev/null 2>&1
    if [ $? -ne 0 ]
    then
        error_status=1
        error_commands="${error_commands}""ldconfig --help ,"
        log ERROR "${checkItemId}FSA_check_chkconfig_info.sh:Command of 'ldconfig --help' execution failed"
    fi


    id --help >/dev/null 2>&1
    if [ $? -ne 0 ]
    then
        error_status=1
        error_commands="${error_commands}""id --help ,"
        log ERROR "${checkItemId}FSA_check_chkconfig_info.sh:Command of 'id --help' execution failed"
    fi


    userdel --help >/dev/null 2>&1
    if [[ $? -eq 0 || $? -eq 2 ]]
    then
        error_status=${error_status}
    else
        error_status=1
        error_commands="${error_commands}""userdel --help ,"
        log ERROR "${checkItemId}FSA_check_chkconfig_info.sh:Command of 'userdel --help' execution failed"
    fi


    lsmod >/dev/null 2>&1
    if [ $? -ne 0 ]
    then
        error_status=1
        error_commands="${error_commands}""lsmod "
        log ERROR "${checkItemId}FSA_check_chkconfig_info.sh:Command of 'lsmod' execution failed"
    fi

    if [ ${error_status} -eq 0 ]
    then
        originalInfo="command:chkconfig --list >/dev/null 2>&1\nservice --help >/dev/null 2>&1\nln --help >/dev/null 2>&1\nldconfig --help >/dev/null 2>&1\nid --help >/dev/null 2>&1\nuserdel --help >/dev/null 2>&1\nlsmod >/dev/null 2>&1\n"
        originalInfo="${originalInfo}""review:all commands output do not have stderr notice.\n"
        originalInfo="${originalInfo}""result:/usr/bin/perl dir is ok"
        log INFO "${checkItemId}:FSA_check_chkconfig_info.sh:ok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    else
        resultCode=1
        errorKey="${checkItemId}0001"    # 0001 /usr/bin/perl 不存在或者目录下部分命令损坏
        originalInfo="command:chkconfig --list >/dev/null 2>&1\nservice --help >/dev/null 2>&1\nln --help >/dev/null 2>&1\nldconfig --help >/dev/null 2>&1\nid --help >/dev/null 2>&1\nuserdel --help >/dev/null 2>&1\nlsmod >/dev/null 2>&1\n"
        originalInfo="${originalInfo}""review:${error_commands} output include stderr notice.\n"
        originalInfo="${originalInfo}""result:/usr/bin/perl dir is damaged , ${error_commands} order is error  ."
        log ERROR "${checkItemId}:FSA_check_chkconfig_info.sh:unok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi

}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}

##############################
#
#  错误码：
#  0001 /usr/bin/perl 不存在或者目录下部分命令损坏
#
##############################