#!/bin/bash

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }

checkItemId="33"
resultCode=0
errorKey=""
params=""
originalInfo=""

main()
{

    local agentMonitor="/opt/dsware/agent/conf/agentMonitor"
    mdc_judg=`cat $agentMonitor | grep mdc|grep -v alarm | grep -E "True" | wc -l`

    if [ ${mdc_judg} -eq 0 ]
    then
        originalInfo="${originalInfo}""result:check mdc cluster id:ok "
        log INFO "${checkItemId}FSA_check_cluster_id:this web_server is not mdc piont."
        log INFO "${checkItemId}:FSA_check_cluster_id:ok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

    local id=`cat /opt/dsware/mdc/conf/mdc_conf.cfg|grep g_cluster_id|awk -F '=' '{print $2}'`
    originalInfo="${originalInfo}""command:cat /opt/dsware/mdc/conf/mdc_conf.cfg|grep g_cluster_id|awk -F '=' '{print \$2}'\n"
    originalInfo="${originalInfo}""review:${id}\n"
    
    if [ $id -ne 0 ]
    then
        resultCode=1
        errorKey="${checkItemId}0001"    # 0001 MDC 配置文件不正确，mdc_conf.cfg 中 g_cluster_id 参数配置有误
        originalInfo="${originalInfo}""result:mdc g_cluster_id not equal 0."
        log ERROR "${checkItemId}FSA_check_cluster_id:mdc g_cluster_id not equal 0."
        log ERROR "${checkItemId}:FSA_check_cluster_id:unok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    else
        originalInfo="${originalInfo}""result:check mdc cluster id:ok "
        log INFO "${checkItemId}:FSA_check_cluster_id:ok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}

##############################
#
#  错误码：
#  0001   MDC 配置文件不正确，mdc_conf.cfg 中 g_cluster_id 参数配置有误 
#
##############################