#!/bin/bash

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/error.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/error.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }

checkItemId="24"
resultCode=0
errorKey=""
params=""
originalInfo=""

main()
{
    local cpu_num=""
    local status="OK"
    cpu_num=`cat /proc/cpuinfo |grep -i processor -c`
    originalInfo="command:cat /proc/cpuinfo |grep -i processor -c\n"
    originalInfo="${originalInfo}""review:total of cpu is ${cpu_num}\n"
    update_version=$(get_package_version)

    if [[ ${update_version} =~ "V100R006C30SPC300" || ${update_version} =~ "V100R006C30SPC500" ]]
    then
        if [ $cpu_num -gt 256 ]
        then
            resultCode=1
            errorKey="${checkItemId}0001"    # 0001: cpu 总数超过标准
            params=""

            originalInfo="${originalInfo}""result:The cpu num is $cpu_num ,beyond 256 "
            log ERROR "${checkItemId}FSA_check_cpu_num:The cpu num is $cpu_num ,beyond 256"
            log ERROR "${checkItemId}:FSA_check_cpu_num:unok"
            FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
            return 1
        else
            resultCode=0
            errorKey=""
            params=""
            originalInfo="${originalInfo}""result:The cpu num is $cpu_num , do not beyond 256 "
            log INFO "The cpu num is $cpu_num , do not beyond 256"
            log INFO "${checkItemId}:FSA_check_cpu_num:ok"
            FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
            return 0
        fi
    fi

    if [[ ${update_version} =~ "V100R006C30SPC501" || ${update_version} =~ "V100R006C30SPH505" ]]
    then
        if [ ${cpu_num} -gt 1024 ]
        then
            resultCode=1
            errorKey="${checkItemId}0001"    # 0001: cpu 总数超过标准
            params=""
            originalInfo="${originalInfo}""result:The cpu num is $cpu_num ,beyond 1024 "
            log ERROR "${checkItemId}FSA_check_cpu_num:The cpu num is $cpu_num ,beyond 1024."
            log ERROR "${checkItemId}:FSA_check_cpu_num:unok"
            FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
            return 1
        else
            resultCode=0
            errorKey=""
            params=""
            originalInfo="${originalInfo}""result:The cpu num is $cpu_num , do not beyond 1024 "
            log INFO "${checkItemId}:FSA_check_cpu_num:ok"
            FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
            return 0
        fi
    fi

    resultCode=0
    errorKey=""
    params=""
    originalInfo="${originalInfo}""result:the cpu num is $cpu_num "
    log INFO "${checkItemId}:FSA_check_cpu_num:ok"
    FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
    return 0

}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}

#################################
#
#  错误码：
#  0001: cpu 总数超过标准
#
#################################