#!/bin/bash

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/error.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/error.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }

checkItemId="23"
resultCode=0
errorKey=""
params=""
originalInfo=""

agentMonitorFile="/opt/dsware/agent/conf/agentMonitor"
backuAgentPath="/opt/dsware/update/backup/Agent/"
totalBackupSize=0
storageBackupSize=0
clientBackupSize=0
controllerBackupSize=0

function addStorageFile()
{
    file=$1
    size=$(du -ck --apparent-size $file | tail -n 1 | awk '{print $1}')
    storageBackupSize=$(expr $storageBackupSize + $size)
}

function addClientFile()
{
    file=$1
    size=$(du -ck --apparent-size $file | tail -n 1 | awk '{print $1}')
    clientBackupSize=$(expr $clientBackupSize + $size)
}

function addControllerFile()
{
    file=$1
    size=$(du -ck --apparent-size $file | tail -n 1 | awk '{print $1}')
    controllerBackupSize=$(expr $controllerBackupSize + $size)
}


function caculStroage()
{
    # 存储节点需要备份的大小
    local CNT_MONITOR=$(cat ${agentMonitorFile}  | grep osd |grep -v alarm | grep -E "True" | wc -l)
    if [ $CNT_MONITOR -eq 0 ]
    then
        log INFO "${checkItemId}FSA_check_disk_space:No need cacul Stroage."
        return 0
    fi
    # backup_program_DSA
    addStorageFile /opt/dsware/FusionStorageCopyrightNotice.zip
    addStorageFile /opt/dsware/agent/bin
    addStorageFile /opt/dsware/agent/lib
    addStorageFile /opt/dsware/agent/script
    addStorageFile /opt/dsware/agent/tool
    addStorageFile /opt/dsware/agent/ko
    addStorageFile /opt/dsware/agent/NVDIMM
    addStorageFile /opt/dsware/agent/interface
    addStorageFile /etc/opensm/ipoib_p_init.sh
    addStorageFile /etc/opensm/ipoib_p_mon_link.sh
    addStorageFile /etc/opensm/path_syn
    addStorageFile /etc/init.d/dsware_attach_volume
    addStorageFile /etc/init.d/dsware_cgroup
    addStorageFile /etc/init.d/dsware_Irq_Affinity
    addStorageFile /etc/init.d/dsware_nvdimm
    addStorageFile /etc/init.d/dswareAgent
    addStorageFile /etc/init.d/dswareStopVBS
    addStorageFile /etc/init.d/opensmd0
    addStorageFile /etc/init.d/opensmd1
    addStorageFile /etc/init.d/opensmd2
    addStorageFile /etc/init.d/opensmd3
    addStorageFile /etc/profile.d/fusionstorage_block.sh
    #backup_program_OSD
    addStorageFile /opt/dsware/osd/bin
    #backup_program_SMIO
    addStorageFile /opt/dsware/osd/ko
    #backup_config_DSA
    addStorageFile /opt/dsware/agent/conf
    addStorageFile /opt/dsware/conf
    #backup_config_OSD
    addStorageFile /opt/dsware/osd/conf

    log INFO "${checkItemId}FSA_check_disk_space:Storage node $backuAgentPath space need ${storageBackupSize}KB"
}

function caculClient()
{
    # 计算需要备份的大小
    local CNT_MONITOR=$(cat ${agentMonitorFile}  | grep -E 'vbs' |grep -v alarm | grep -E "True" | wc -l)
    if [ $CNT_MONITOR -eq 0 ]
    then
        log INFO "${checkItemId}FSA_check_disk_space:No need cacul Client."
        return 0
    fi
    # backup_program_VBS
    addClientFile /opt/dsware/vbs/bin
    addClientFile /usr/bin/vbs_cli
    addClientFile /opt/dsware/vbs/script

    #backup_program_VSC
    addClientFile /opt/dsware/vbs/ko

    addClientFile /opt/dsware/vfs/bin
    addClientFile /opt/dsware/vfs/script
    addClientFile /opt/dsware/kvs/bin

    #backup_config_VBS
    addClientFile /opt/dsware/vbs/conf
    addClientFile /opt/dsware/vfs/conf
    addClientFile /opt/dsware/kvs/conf
    log INFO "${checkItemId}FSA_check_disk_space:Client node $backuAgentPath space need ${clientBackupSize}KB"
}

function caculController()
{
    # 控制节点需要备份的大小
    local CNT_MONITOR=$(cat ${agentMonitorFile}  | grep -E 'mdc|zk' |grep -v alarm | grep -E "True" | wc -l)
    if [ $CNT_MONITOR -eq 0 ]
    then
        log INFO "${checkItemId}FSA_check_disk_space:No need cacul Controller."
        return 0
    fi
    addControllerFile /opt/dsware/agent/jre-*.tar.gz
    addControllerFile /opt/dsware/agent/zk/bin
    addControllerFile /opt/dsware/agent/zk/lib
    addControllerFile /opt/dsware/mdc/bin
    addControllerFile /opt/dsware/agent/zk/conf
    addControllerFile /opt/dsware/mdc/conf

    log INFO "${checkItemId}FSA_check_disk_space:Controller node $backuAgentPath space need ${controllerBackupSize}KB"
}

function caculOptBackupSpace() {
    # 存储节点需要备份的大小
    caculStroage
    # 控制节点需要备份的大小
    caculController
    # 计算节点需要备份的大小
    caculClient

    totalBackupSize=`expr $storageBackupSize + $clientBackupSize + $controllerBackupSize`
    log INFO "${checkItemId}FSA_check_disk_space: totalBackupSize($totalBackupSize) = storageBackupSize($storageBackupSize) + controllerBackupSize($controllerBackupSize)"
}

main()
{
    local status="OK"

    # 计算备份FSA需要的容量
    caculOptBackupSpace
    local space_backup_Available=$(df -kP `dirname "${backuAgentPath}"` |tail -n1 | awk '{print $4}')
    originalInfo="${originalInfo}""command:df -kP `dirname "${backuAgentPath}"` |tail -n1 | awk '{print $4}'\n"
    originalInfo="${originalInfo}""review:${backuAgentPath} space ${space_backup_Available}\n"
    if [ $totalBackupSize -gt $space_backup_Available ]
    then
        status="UNOK"
        error_num_4=8
        originalInfo="${originalInfo}""result:${backuAgentPath} space(${space_backup_Available}KB) is not enough(${totalBackupSize}KB)\n"
        log ERROR "${checkItemId}FSA_check_disk_space:${backuAgentPath} space(${space_backup_Available}KB) is not enough(${totalBackupSize}KB)"
    else
        error_num_4=0
        originalInfo="${originalInfo}""result:${backuAgentPath} space(${space_backup_Available}KB) is enough(${totalBackupSize}KB)\n"
    fi

    local space_opt_Available=$(df -kP "/opt" |tail -n1 | awk '{print $4}')
    originalInfo="${originalInfo}""command:df -kP /opt | tail -n 1 | awk '{print \$4}'\n"
    originalInfo="${originalInfo}""review:/opt space ${space_opt_Available}\n"
    if [ $space_opt_Available -lt 2097152 ]
    then 
        status="UNOK"
        error_num_1=1
        originalInfo="${originalInfo}""result:/opt space is not enough(2G)\n"
        log ERROR "${checkItemId}FSA_check_disk_space:/opt space is not enough(2G)"
    else
        error_num_1=0
        originalInfo="${originalInfo}""result:/opt space is enough(2G)\n"
    fi
    

    local space_varlog_Available=$(df -kP "/var/log" |tail -n1 | awk '{print $4}')
    originalInfo="${originalInfo}""command:df -kP /var/log |tail -n1 | awk '{print \$4}'\n"
    originalInfo="${originalInfo}""review:/var/log space ${space_varlog_Available}\n" 
    if [ $space_varlog_Available -lt 307200 ]
    then 
        status="UNOK"
        error_num_2=2
        originalInfo="${originalInfo}""result:/var/log space is not enough(300M)\n"
        log ERROR "${checkItemId}FSA_check_disk_space:/var/log space is not enough(300M)"
    else
        error_num_2=0
        originalInfo="${originalInfo}""result:/var/log space is enough(300M)\n"
    fi

    local space_tmp_Available=$(df -kP "/tmp" |tail -n1 | awk '{print $4}')
    originalInfo="${originalInfo}""command:df -kP "/tmp" |tail -n1 | awk '{print \$4}'\n"
    originalInfo="${originalInfo}""review:/tmp space ${space_tmp_Available}\n"
    if [ $space_tmp_Available -lt 10240 ]   
    then
        status="UNOK"
        error_num_3=4
        originalInfo="${originalInfo}""result:/tmp space is not enough(10M)"
        log ERROR "${checkItemId}FSA_check_disk_space:/tmp space is not enough(10M)"
    else
        error_num_3=0
        originalInfo="${originalInfo}""result:/tmp space is enough(10M)"
    fi
    
    if [[ $status =~ "UNOK" ]]
    then
        resultCode=1
        errorKey="${checkItemId}0000"
        error_total=$[${error_num_1}+${error_num_2}+${error_num_3}+${error_num_4}]
        errorKey=$[${errorKey}+${error_total}]
        params=""
        log ERROR "${checkItemId}:FSA_check_disk_space:unok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    else
        resultCode=0
        params=""
        log INFO "${checkItemId}:FSA_check_disk_space:ok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi
}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}



##############################
#
#  错误码：
#  0001 /opt                          目录空间不足
#  0002 /var/log                      目录空间不足
#  0003 /opt and /var/log             目录空间不足
#  0004 /tmp                          目录空间不足
#  0005 /tmp and /opt                 目录空间不足
#  0006 /tmp and /var/log             目录空间不足
#  0007 /tmp and /opt and /var/log    目录空间不足
#
##############################