#!/bin/bash

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"
PATH="/sbin:/usr/sbin:/usr/local/sbin:/root/bin:/usr/local/bin:/usr/bin:/bin:/opt/omm/oma/workspace/tools"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }

checkItemId="46"
resultCode=0
errorKey=""
params=""
originalInfo=""

main()
{

    service hcp status  >/dev/null 2>&1
    status_1=$?
    originalInfo="command:service hcp status >/dev/null 2>&1\n"
    originalInfo="${originalInfo}""review:\$? equal ${status_1}\n"
    
    cat /opt/huawei-data-protection/ebackup/conf/version.conf >/dev/null 2>&1
    status_2=$?
    originalInfo="${originalInfo}""command:cat /opt/huawei-data-protection/ebackup/conf/version.conf >/dev/null 2>&1\n"
    originalInfo="${originalInfo}""review:\$? equal ${status_2}\n"

    #如果两个命令没有返回，则符合ok
    if [ $status_1 -eq 0 ] || [ $status_2 -eq 0 ]
    then
        resultCode=1
        errorKey="${checkItemId}0001"  #  0001 计算节点存在 ebackup
        originalInfo="${originalInfo}""result:this web server has ebackup."
        log ERROR "${checkItemId}FSA_check_ebackup:this web server has ebackup."
        log ERROR "${checkItemId}:FSA_check_ebackup:unok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    else
        originalInfo="${originalInfo}""result:check ebackup:ok"
        log INFO "${checkItemId}:FSA_check_ebackup:ok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}

##############################
#
#  错误码：
#  0001 计算节点存在 ebackup
#
##############################