#!/bin/bash

#############################################################
#
# 名  称：检查ES3000 V5寿命
# 错误码：
#  0001 #  0001 升级华为V5盘FW版本到3257及之后.
#############################################################
PATH="/sbin:/usr/sbin:/usr/local/sbin:/root/bin:/usr/local/bin:/usr/bin:/bin:/opt/omm/oma/workspace/tools"
UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"
source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }

checkItemId="1223"
resultCode=0
errorKey=""
params=""
originalInfo=""

agentMonitorFile="/opt/dsware/agent/conf/agentMonitor"
NET_FILTER_CFG_PATH="/proc/sys/net/netfilter/"

CODE_WHITELIST="
03032YHR 55
03033AUN 67
03033CQQ 72
03033FKM 73
03034AUT 55
03034AUU 55
03033FJB 72
03033FKF 72
03032WFN 55
03033BCW 55
03033FWL 67
03032WFM 55
03033FBL 72
03033GTB 72
03033JPV 55
03033JTC 73
03033QGV 72
03033QGW 73
03033QGY 55
03032VUA 55
03033FWK 67
03032WGK 28
03033AAX 28
03032YRE 55
03033BPF 55
03033GJS 72
03033BDA 55
03033FKJ 73
03033RXK 73
03033GSK 73
03033QRJ 73
03032WET 55
03033AXP 55
03032VUL 55
03032WEJ 55
03032WEP 55
03032YWH 67
03033AUP 67
03033CQU 72
03033CQV 72
03033GDP 72
03032WFG 28
03032VUM 28
03032WEK 28
03032WEQ 28
03032WFB 28
03033CWY 72
03033LBA 37
03032WFA 55
03032WFF 55
03032YHV 55
03033FJH 73
03033FKH 73
03033FJK 73
03033FKL 73
03033FKN 73
03033BGA 55
03033FAM 55
03033BGB 28
03033FAW 28
"

FW_WHITELIST="
1009
1010
1011
1012
1022
1025
1026
1027
1030
1031
1033
1035
1036
1037
1038
2130
2131
2150
2151
2152
2153
2155
2156
2158
2252
3216
3220
3221
3222
3230
3231
3232
3233
3234
3235
3241
3242
3243
3245
3246
3247
3248
3252
3253
3255
"

##############################################################
## 检查是否为存储节点
## 返回值：0 存在节点，1 不是存储节点
##############################################################
function checkOSDNode()
{
    # 监控文件不存在
    if [ ! -f ${agentMonitorFile} ]
    then
        return 1
    fi
    # 检查是否有OSD监控
    local osd_judg=`cat ${agentMonitorFile} | grep osd | grep monitor | grep True | wc -l`
    if [ ${osd_judg} -eq 0 ]
    then
        return 1
    fi

    return 0
}

##############################################################
## 计算剩余时间
##############################################################
function calcTimeRemaining()
{
    # 输入参数 参数1: diskInfo show_disk的一条信息  参数2: sn
    # 输出参数 全局变量 剩余寿命
    # 返回值 0:获取剩余寿命成功; 1:smartctl工具执行失败; 2：获取寿命和上电时间失败; 3:上电时间为零; 4:寿命超门限 5:上电时间小于寿命百分比
    local lineInfo=$1
    local sn=$2
    local device=`echo $lineInfo | awk -F"|" '{print $3}' | sed -e 's/ //g'`
    local diskType=`echo $lineInfo | grep "SAS_SSD"`

    if [ ! -z "$diskType" ] || [[ "$device" =~ "sd" ]];then
        smartctl_life_temp=`timeout 30 smartctl -a /dev/$device`
        if [ $? -ne 0 ];then
            return 1
        fi
        smartctl_time_temp=`timeout 30 smartctl -l background /dev/$device`
        if [ $? -ne 0 ];then
            return 1
        fi
        powerOnTime=`awk -F ':' '/'power\ on\ time'/{printf("%s", $2)}' <<< "$smartctl_time_temp" | awk -F" " '{print $2}' | sed -e 's/[ ]//g' | sed -e 's/,//g' | grep -v '[A-Z|a-z]'`
        percentageUsed=`awk -F ':' '/'"(Percentage|Media)"\ used\ endurance\ indicator'/{printf("%s", $2)}' <<< "$smartctl_life_temp" | sed -e 's/[ ]//g' | sed -e 's/[%]*$//g' | grep -v '[A-Z|a-z]'`
    else
        hioadm_temp=`hioadm info -d $device -s`
        if [ $? -ne 0 ];then
            local smio_path=$(ls -l /proc/`pidof smio_jbodmng` | grep smio_jbodmng | awk '{print $11}' | xargs dirname)
            smio_nvme_cli_temp=$(timeout 30 ${smio_path}/tools/smio_nvme_cli /dev/${device})
            if [ $? -ne 0 ];then
                return 1
            fi
            powerOnTime=`awk -F ':' '/'power_on_hours'/{printf("%s", $2)}' <<< "$smio_nvme_cli_temp" | sed -e 's/[ ]//g'| sed -e 's/,//g' | grep -v '[A-Z|a-z]'`
            percentageUsed=`awk -F ':' '/'percentage_used'/{printf("%s", $2)}' <<< "$smio_nvme_cli_temp" | sed -e 's/[ ]//g' | sed -e 's/[%]*$//g' | grep -v '[A-Z|a-z]'`
        else
            powerOnTime=`awk -F ':' '/'power\ on\ hours'/{printf("%s", $2)}' <<< "$hioadm_temp" | sed -e 's/[ ]//g' | sed -e 's/,//g'  | sed -e 's/[a-z|A-Z]//g' | grep -v '[A-Z|a-z]'`
            percentageUsed=`awk -F ':' '/'percentage\ used'/{printf("%s", $2)}' <<< "$hioadm_temp" | sed -e 's/[ ]//g' | sed -e 's/[%]*$//g' | grep -v '[A-Z|a-z]'`
        fi
    fi
    local percentagLimt=`awk -F ' ' '/'03${sn:0:6}'/{printf("%d", $2)}' <<< "$CODE_WHITELIST"`
    if [ -z "$powerOnTime" ] || [ -z "$percentageUsed" ]; then  # 工具获取寿命和上电时间失败
        return 2
    fi
    
    if [ $powerOnTime -eq 0 ] || [ $percentageUsed -eq 0 ] || [ $percentagLimt -eq 0 ];then  # 上电时间或使用寿命百分比为0
        return 3
    fi

    local avgTime=$(($powerOnTime/$percentageUsed))
    if [ $avgTime -eq 0 ];then # 整除为0的场景
        return 5
    fi

    local allTime=$(($avgTime*$percentagLimt))
    local timeRemainingHour=$(($allTime-$powerOnTime - 30 * 24))
    timeRemaining=$(($timeRemainingHour/24))
    percentageTure=$(($percentageUsed*100/$percentagLimt))
    if [ $timeRemaining -le 0 ];then  # 上报风险，并打印没有剩余时间
        timeRemaining=0
        return 4
    fi
    # 上报风险，并打印剩余时间
    return 0
}

main()
{
    agent_items_check ${checkItemId}
    if [ $? -ne 0 ]
    then
        log INFO "${checkItemId} do not select, pass"
        return 0
    fi

    # 检查是否为风险节点版本
    local nodePath="/opt/dsware/DSwareAgentNodeVersion"
    local nodeVersion=`cat $nodePath | grep "nodeVersion" | awk -F'=' '{print $2}' | sed -e 's/[ ]//g' | grep -E 'V100R006'`
    if [ -z "$nodeVersion" ];then
        originalInfo="NodeVersion is not risk, no need to check."
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

    # 检查是否为存储节点
    checkOSDNode
    ret=$?
    if [[ ${ret} -ne 0 ]];then
        originalInfo="Not storage node, no need check."
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

    local diskInfo=`cat /proc/smio_host | grep -E "HSSD-D6|HWE5"`
    if [ -z "$diskInfo" ];then
        originalInfo="This node does not have a ES3000/HSSD V5 disk. No need check."
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

    smartctlIsOk=1
    while read line
    do
        local sn=`echo $line | awk -F"|" '{print $7}' | sed -e 's/[ ]//g'`
        local fw=`echo $line | awk -F"|" '{print $8}' | awk -F"," '{print $3}' | sed -e 's/[ ]//g' | grep '^[0-9]\{4\}'`
        local isRiskFw=`grep "$fw" <<< "$FW_WHITELIST"`
        if [ -z "$fw" ] || [ -z "$isRiskFw" ];then
            log INFO "Disk sn:${sn},  fw version is higher than 3255, no need check."
            continue
        fi
        
        local isRisk0303=`awk -F ' ' '$1=="03'${sn:0:6}'" {printf("%s", $1)}' <<< "$CODE_WHITELIST"`
        if [ -z "$isRisk0303" ];then
            log INFO "Disk sn:${sn}, not exist risk , no need check."
            continue
        fi
        
        powerOnTime=NA
        percentageUsed=NA
        timeRemaining=NA
        percentageTure=NA
        errCode=NA
        if [ $smartctlIsOk -eq 1 ];then
            calcTimeRemaining "$line" "$sn"
            errCode=$?

            if [ $errCode -eq 1 ] ||  [ $errCode -eq 2 ];then
                smartctlIsOk=0
            fi
        fi

        resultCode=1
        originalInfo="${originalInfo}Disk sn:${sn} fw:$fw exist risk, time remaining:${timeRemaining}d powerOnTime:${powerOnTime}h percentageUsed:${percentageUsed}% percentageTure:${percentageTure}% code:$errCode, suggestions upgrade disk to 3257 or latter.\n"
        log ERROR "Disk sn:${sn} fw:$fw exist risk, time remaining:${timeRemaining}d powerOnTime:${powerOnTime}h percentageUsed:${percentageUsed}% percentageTure:${percentageTure}% code:$errCode, suggestions upgrade disk to 3257 or latter." ${FUNCNAME} ${SCRIPT_NAME} # 报不通过，以及剩余时间
    done <<< "$diskInfo"

    if [[ $resultCode -eq 0 ]];then
        originalInfo="This node has no risk."
    else
        errorKey="${checkItemId}000$resultCode"
    fi

    FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
    return $resultCode
}

log MUST "enter [$0],para=[$@]"
main
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}

##############################
#
#  错误码：
#  0001 es3000 V5硬盘存在寿命风险.
##############################