#!/bin/bash
PATH="/sbin:/usr/sbin:/usr/local/sbin:/root/bin:/usr/local/bin:/usr/bin:/bin:/opt/omm/oma/workspace/tools"
UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }

checkItemId="51"
resultCode=0
errorKey=""
params=""
originalInfo=""

main()
{
    if [[ ! $(get_package_version) =~ V100R006C30 ]]
    then 
        resultCode=0
        originalInfo="The target version is not V100R006C30,no need check"
        log INFO "${checkItemId}FSA_check_ib_bond.sh:The target version is not V100R006C30,no need check"
        log INFO "${checkItemId}:FSA_check_ib_bond.sh:ok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

    error_status_vbs=1
    error_status_osd=1

    local IB_net_judg=`cat /opt/dsware/agent/conf/network.cfg | grep -i infiniband`

    if [[ -z "${IB_net_judg}" ]]
    then
        originalInfo="${originalInfo}""result:this FSA network type is not infiniband, no need to check."
        log INFO "${checkItemId}FSA_check_ib_bond:this FSA network type is not infiniband, no need to check."
        log INFO "${checkItemId}:FSA_check_ib_bond:ok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    else
        local agentMonitor="/opt/dsware/agent/conf/agentMonitor"
        vbs_judg=`cat $agentMonitor | grep vbs|grep -v alarm | grep -E "True" | wc -l`
        osd_judg=`cat $agentMonitor | grep osd|grep -v alarm | grep -E "True" | wc -l`

        if [ ${vbs_judg} -gt 0 ]
        then
            vbs_net_type=`cat /opt/dsware/vbs/conf/vbs_*_conf.cfg | grep g_net_physical | awk -F '=' '{print$2}'`
            originalInfo="${originalInfo}""command:cat /opt/dsware/vbs/conf/vbs_*_conf.cfg | grep g_net_physical | awk -F '=' '{print\$2}'\n"
            originalInfo="${originalInfo}""review:vbs_net_type is ${vbs_net_type}\n"
            if [[ "${vbs_net_type}"x == "ibv"x ]]
            then
                if [ -d "/proc/net/bonding" ]
                then
                    network_interface_have=`ls /proc/net/bonding/`
                    originalInfo="${originalInfo}""command:ls /proc/net/bonding/\n"
                    originalInfo="${originalInfo}""review:network_interface_existence have ${network_interface_have}\n"
                    storage_ip=`cat /opt/dsware/agent/conf/node_storage_ip | awk -F '=' '{print$2}'`
                    originalInfo="${originalInfo}""command:cat /opt/dsware/agent/conf/node_storage_ip | awk -F '=' '{print\$2}'\n"
                    originalInfo="${originalInfo}""result:storage_ip is ${storage_ip}\n"
                    network_interface_name=`ip a | grep "${storage_ip}" | awk '{print$7}'`
                    originalInfo="${originalInfo}""command:ip a | grep ${storage_ip} | awk '{print\$7}'\n"
                    originalInfo="${originalInfo}""review:network_interface_name is ${network_interface_name}\n"
                    for i in ${network_interface_have}
                    do
                        if [[ "${network_interface_name}"x == "${i}"x ]]
                        then
                            error_status_vbs=0
                            originalInfo="${originalInfo}""result:this FSA network(vbs) is ibv and ${network_interface_name} in /proc/net/bonding.\n"
                            log INFO "${checkItemId}FSA_check_ib_bond:this FSA network(vbs) is ibv and ${network_interface_name} in /proc/net/bonding."
                        fi
                    done
                else
                    resultCode=1
                    errorKey="${checkItemId}0001"    #  0001 该 FSA 节点网络类型为ibv，且没有 /proc/net/bonding 目录
                    originalInfo="${originalInfo}""result:this FSA network is ibv , but this FSA do not have /proc/net/bonding dir."
                    log ERROR "${checkItemId}FSA_check_ib_bond:this FSA network is ibv , but this FSA do not have /proc/net/bonding dir."
                    log ERROR "${checkItemId}:FSA_check_ib_bond:unok"
                    FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
                    return 1
                fi
            else
                error_status_vbs=0
            fi
        else
            error_status_vbs=0
        fi

        if [ ${osd_judg} -gt 0 ]
        then
            osd_net_type=`cat /opt/dsware/osd/conf/osd_*_conf.cfg | grep g_net_physical | awk -F '=' '{print$2}'`
            originalInfo="${originalInfo}""command:cat /opt/dsware/osd/conf/osd_*_conf.cfg | grep g_net_physical | awk -F '=' '{print\$2}'\n"
            originalInfo="${originalInfo}""review:vbs_net_type is ${osd_net_type}\n"
            if [[ "${osd_net_type}"x == "ibv"x ]]
            then
                if [ -d "/proc/net/bonding" ]
                then
                    network_interface_have=`ls /proc/net/bonding/`
                    originalInfo="${originalInfo}""command:ls /proc/net/bonding/\n"
                    originalInfo="${originalInfo}""review:network_interface_existence have ${network_interface_have}\n"
                    storage_ip=`cat /opt/dsware/agent/conf/node_storage_ip | awk -F '=' '{print$2}'`
                    originalInfo="${originalInfo}""command:cat /opt/dsware/agent/conf/node_storage_ip | awk -F '=' '{print\$2}'\n"
                    originalInfo="${originalInfo}""result:storage_ip is ${storage_ip}\n"
                    network_interface_name=`ip a | grep "${storage_ip}" | awk '{print$7}'`
                    originalInfo="${originalInfo}""command:ip a | grep ${storage_ip} | awk '{print\$7}'\n"
                    originalInfo="${originalInfo}""review:network_interface_name is ${network_interface_name}\n"
                    for i in ${network_interface_have}
                    do
                        if [[ "${network_interface_name}"x == "${i}"x ]]
                        then
                            error_status_osd=0
                            originalInfo="${originalInfo}""result:this FSA network(osd) is ibv and ${network_interface_name} in /proc/net/bonding.\n"
                            log INFO "${checkItemId}FSA_check_ib_bond:this FSA network(osd) is ibv and ${network_interface_name} in /proc/net/bonding."
                        fi
                    done
                else
                    resultCode=1
                    errorKey="${checkItemId}0001"    #  0001 该 FSA 节点网络类型为ibv，且没有 /proc/net/bonding 目录
                    originalInfo="${originalInfo}""result:this FSA network is ibv , but this FSA do not have /proc/net/bonding dir."
                    log ERROR "${checkItemId}FSA_check_ib_bond:this FSA network is ibv , but this FSA do not have /proc/net/bonding dir."
                    log ERROR "${checkItemId}:FSA_check_ib_bond:unok"
                    FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
                    return 1
                fi
            else
                error_status_osd=0
            fi
        else
            error_status_osd=0
        fi
    fi

    if [ ! -d "/sys/class/net/${network_interface_name}" ]
    then
        resultCode=1
        errorKey="${checkItemId}0003"    #  0003 该 FSA 是 IB 组网，但未生成网口目录 /sys/class/net/网口名
        originalInfo="${originalInfo}""result:this point is IB_net , but do not have /sys/class/net/${network_interface_name} dir."
        log ERROR "${checkItemId}FSA_check_ib_bond:this point is IB_net , but do not have /sys/class/net/${network_interface_name} dir."
        log ERROR "${checkItemId}:FSA_check_ib_bond:unok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi

    ib_net_card_port=`cat /sys/class/net/${network_interface_name}/bonding/slaves`

    for port in ${ib_net_card_port}
    do
        local port_in_net_card=`ibdev2netdev | grep "${port}" | awk '{print$1}'`
        local net_card_have_port=`ibdev2netdev | grep "${port_in_net_card}" | awk '{print$5}'`
        for net_port in ${net_card_have_port}
        do
            if [[ ! "${ib_net_card_port}" =~ "${net_port}" ]]
            then
                resultCode=1
                errorKey="${checkItemId}0004"    #  0004 有额外的网卡上的端口，未记录在 /sys/class/net/网口名/bongding/slaves 文件中
                originalInfo="${originalInfo}""result:${net_port} net_port in ${port_in_net_card} net_card is not in /sys/class/net/${network_interface_name}/bonding/slaves file."
                log ERROR "${checkItemId}FSA_check_ib_bond:${net_port} net_port in ${port_in_net_card} net_card is not in /sys/class/net/${network_interface_name}/bonding/slaves file."
                log ERROR "${checkItemId}:FSA_check_ib_bond:unok"
                FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
                return 1
            fi
        done
    done


    if [ "${error_status_osd}" -eq 1 -o "${error_status_vbs}" -eq 1 ]
    then
        resultCode=1
        errorKey="${checkItemId}0002"    #  0002 该 FSA 节点网络类型为ibv且网口不在 /proc/net/bonding 目录下
        originalInfo="${originalInfo}""result:this FSA network is ibv and ${network_interface_name} is not in /proc/net/bonding."
        log ERROR "${checkItemId}FSA_check_ib_bond:this FSA network is ibv and ${network_interface_name} is not in /proc/net/bonding."
        log ERROR "${checkItemId}:FSA_check_ib_bond:unok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    else
        log INFO "${checkItemId}:FSA_check_ib_bond:ok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi
}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}

##############################
#
#  错误码：
#  0001 该 FSA 节点网络类型为ibv，且没有 /proc/net/bonding 目录
#  0002 该 FSA 节点网络类型为ibv且网口不在 /proc/net/bonding 目录下
#  0003 该 FSA 是 IB 组网，但未生成网口目录 /sys/class/net/网口名
#  0004 有额外的网卡上的端口，未记录在 /sys/class/net/网口名/bongding/slaves 文件中
#
##############################