#!/bin/bash

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/error.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/error.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }

checkItemId="25"
resultCode=0
errorKey=""
params=""
originalInfo=""

main()
{
    local status="OK"
    local version=`cat /opt/dsware/DSwareAgentNodeVersion|grep nodeVersion|awk -F '=' '{print $2}'`
    originalInfo="command:cat /opt/dsware/DSwareAgentNodeVersion|grep nodeVersion|awk -F '=' '{print \$2}'\n"
    originalInfo="${originalInfo}""review:FSA version:${version}\n"
    local agentMonitor="/opt/dsware/agent/conf/agentMonitor"
    error_mdc_num=0
    error_osd_num=0
    error_vbs_num=0
    
    
    if [[ $version =~ "V100R006C00" ]]||[[ $version =~ "V100R003" ]]
    then
        resultCode=0
        errorKey=""
        params=""
        originalInfo="${originalInfo}""result:FSA version is V100R006C00 or V100R003\n"
        log INFO "${checkItemId}:FSA_check_ib_devs:ok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi  
    
    mdc_judg=`cat $agentMonitor | grep mdc|grep -v alarm | grep -E "True" | wc -l`
    if [ ${mdc_judg} -gt 0 ]
    then 
        local config1=`cat /opt/dsware/mdc/conf/mdc_conf.cfg|grep g_net_dev_name|awk -F '=' '{print $2}'`
        originalInfo="${originalInfo}""command:cat /opt/dsware/mdc/conf/mdc_conf.cfg|grep g_net_dev_name|awk -F '=' '{print \$2}'\n"
        originalInfo="${originalInfo}""review:g_net_dev_name=${config1}\n"
        if [[ "${config1}"x == "default_all_ib_dev"x ]]
        then
            error_mdc_num=0
        else
            status="UNOK"
            resultCode=1
            error_mdc_num=1
            params=""
            originalInfo="${originalInfo}""result:mdc_conf.cfg g_net_dev_name not be default_all_ib_dev\n"
            log ERROR "${checkItemId}FSA_check_ib_devs:mdc_conf.cfg g_net_dev_name not be default_all_ib_dev"
        fi
    fi
    
    osd_judg=`cat $agentMonitor | grep osd|grep -v alarm | grep -E "True" | wc -l`    
    if [ ${osd_judg} -gt 0 ]
    then
        local config2=`cat /opt/dsware/osd/conf/osd_*_conf.cfg|grep g_net_dev_name|awk -F '=' '{print $2}' | tr "\n" " "`
        originalInfo="${originalInfo}""command:cat /opt/dsware/osd/conf/osd_*_conf.cfg|grep g_net_dev_name|awk -F '=' '{print \$2}'\n"
        originalInfo="${originalInfo}""review:g_net_dev_name=${config2}\n"
        for info in ${config2}
        do
            if [[ "${info}"x == "default_all_ib_dev"x ]]
            then
                error_osd_num=0
            else
                status="UNOK"
                resultCode=1
                error_osd_num=2
                params=""
                originalInfo="${originalInfo}""result:osd_conf.cfg g_net_dev_name not be default_all_ib_dev\n"
                log ERROR "${checkItemId}FSA_check_ib_devs:osd_conf.cfg g_net_dev_name not be default_all_ib_dev"
            fi
        done
    fi
    
    vbs_judg=`cat $agentMonitor | grep vbs|grep -v alarm | grep -E "True" | wc -l`    
    if [ ${vbs_judg} -gt 0 ]
    then
        local config3=`cat /opt/dsware/vbs/conf/vbs_*_conf.cfg|grep g_net_dev_name|awk -F '=' '{print $2}'`
        originalInfo="${originalInfo}""command:cat /opt/dsware/vbs/conf/vbs_*_conf.cfg|grep g_net_dev_name|awk -F '=' '{print \$2}'\n"
        originalInfo="${originalInfo}""review:g_net_dev_name=${config3}\n"
        if [[ "${config3}"x == "default_all_ib_dev"x ]]
        then       
            error_vbs_num=0
        else
            status="UNOK"
            resultCode=1
            error_vbs_num=4
            params=""
            originalInfo="${originalInfo}""result:vbs_conf.cfg g_net_dev_name not be default_all_ib_dev\n"
            log ERROR "${checkItemId}FSA_check_ib_devs:vbs_conf.cfg g_net_dev_name not be default_all_ib_dev"
        fi
    fi  

    if [[ ${status} == "OK" ]]
    then
        resultCode=0
        errorKey=""
        params=""
        originalInfo="${originalInfo}""result:FSA_check_lib_devs is ok"
        log INFO "${checkItemId}:FSA_check_ib_devs:ok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    else
        resultCode=1
        errorKey="${checkItemId}0000"
        error_total=$[${error_mdc_num}+${error_osd_num}+${error_vbs_num}]
        errorKey=$[${errorKey}+${error_total}]
        log ERROR "${checkItemId}:FSA_check_ib_devs:unok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi
}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}


##############################
#
#  错误码：
#  0001 MDC            配置文件中 g_net_dev_name 参数未使用默认值
#  0002 OSD            配置文件中 g_net_dev_name 参数未使用默认值
#  0003 MDC,OSD        配置文件中 g_net_dev_name 参数未使用默认值
#  0004 VBS            配置文件中 g_net_dev_name 参数未使用默认值
#  0005 VBS,MDC        配置文件中 g_net_dev_name 参数未使用默认值
#  0006 VBS,OSD        配置文件中 g_net_dev_name 参数未使用默认值
#  0007 VBS,OSD,MDC    配置文件中 g_net_dev_name 参数未使用默认值
#
##############################