#!/bin/bash

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"
PATH="/sbin:/usr/sbin:/usr/local/sbin:/root/bin:/usr/local/bin:/usr/bin:/bin:/opt/omm/oma/workspace/tools"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }

checkItemId="27"
resultCode=0
errorKey=""
params=""
originalInfo=""

main()
{
    local IB_net_judg=`cat /opt/dsware/agent/conf/network.cfg | grep -i infiniband`

    if [[ -z "${IB_net_judg}" ]]
    then
        originalInfo="${originalInfo}""result:this FSA network type is not infiniband, no need to check."
        log INFO "${checkItemId}FSA_check_ib_lib:this FSA network type is not infiniband, no need to check."
        log INFO "${checkItemId}:FSA_check_ib_lib:ok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

    ib_info=`ib_write_bw -h|grep -i usage`
    log INFO "ib_info:"`ib_write_bw -h|grep -i usage`
    originalInfo="${originalInfo}""command:ib_write_bw -h |grep -i 'usage'\n"
    originalInfo="${originalInfo}""review:`echo $ib_info`\n"
    if [ -z "$ib_info" ]
    then
        resultCode=1
        errorKey="${checkItemId}0001"    # IB 库可能不正确
        originalInfo="${originalInfo}""result:ib lib maybe incorrect"
        log ERROR "${checkItemId}FSA_Check_ib_lib.sh:ib lib maybe incorrect."
        log ERROR "${checkItemId}:FSA_Check_ib_lib.sh:unok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    else       
        originalInfo="${originalInfo}""result:check ib lib:ok"
        log INFO "${checkItemId}:FSA_check_ib_lib.sh:ok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}

##############################
#
#  错误码：
#  0001  IB 库可能不正确
#
##############################