#!/bin/bash

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }

checkItemId="45"
resultCode=0
errorKey=""
params=""
originalInfo=""

main()
{
    local agentMonitor="/opt/dsware/agent/conf/agentMonitor"
    local vbs_judg=`cat $agentMonitor | grep vbs|grep -v alarm | grep -E "True" | wc -l`    
    if [ ${vbs_judg} -eq 0 ]
    then
        originalInfo="result:this web_server is not VBS point."
        log INFO "This web_server is not VBS point."
        log INFO "${checkItemId}:FSA_check_iscsi_transport_key.sh:ok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi  

    review_of_key=`cat /opt/dsware/vbs/conf/transport_work_key.key`
    if [ $? -ne 0 ]
    then
        resultCode=2
        errorKey="${checkItemId}0002"    #  0002 系统中无/opt/dsware/vbs/conf/transport_work_key.key
        originalInfo="command:cat /opt/dsware/vbs/conf/transport_work_key.key\n"
        originalInfo="${originalInfo}""review:not found /opt/dsware/vbs/conf/transport_work_key.key.\n"
        originalInfo="${originalInfo}""result:server not found /opt/dsware/vbs/conf/transport_work_key.key"
        log ERROR "${checkItemId}FSA_check_iscsi_transport_key.sh:server not found /opt/dsware/vbs/conf/transport_work_key.key."
        log ERROR "${checkItemId}:FSA_check_iscsi_transport_key.sh:unok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    else
        originalInfo="command:cat /opt/dsware/vbs/conf/transport_work_key.key\n"
        originalInfo="${originalInfo}""review:${review_of_key}\n"
        if [[ ${review_of_key}x == '59516D4C4C503643434E5158794950687607BF24E4BC8BB2F4C15EBDE02CCAC698676B4EE7B7165E361F1A0D3D13AA767E6843DA4692ABD2A55EF43A2278437F'x ]]
        then
            originalInfo="${originalInfo}""result:transport key is right."
            log INFO "${checkItemId}FSA_check_iscsi_transport_key.sh:transport key is right."
            log INFO "${checkItemId}:FSA_check_iscsi_transport_key.sh:ok"
            FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
            return 0
        else
            resultCode=1
            errorKey="${checkItemId}0001"    #  0001 CVM 中传输密钥不正确
            originalInfo="${originalInfo}""result:CVM transport secret key is wrong."
            log ERROR "${checkItemId}FSA_check_iscsi_transport_key.sh:CVM transport secret key is wrong."
            log ERROR "${checkItemId}:FSA_check_iscsi_transport_key.sh:unok"
            FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
            return 1
        fi
    fi

}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}

##############################
#
#  错误码：
#  0001 CVM 中传输密钥不正确
#  0002 系统中无/opt/dsware/vbs/conf/transport_work_key.key
#
##############################