#!/bin/bash

cd $(dirname $0)
g_curPath="$PWD"
g_scriptName="$(basename $0)"
cd - >> /dev/null

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }

#输出到json文件中的checkItemId,每个检查脚本一个id
checkItemId="63"
resultCode=0
errorKey=""
params=""
originalInfo=""
#获取升级目标版本
tar_version="$(get_package_version)"

systemFile="/etc/system-release"
VBS_KO_PATH="/opt/dsware/vbs/ko/"
OSD_KO_PATH="/opt/dsware/osd/ko/"

function is_suse_or_oracle()
{
    ls /etc/SuSE* >/dev/null 2>&1
    is_suse=$?
    if [ $is_suse -eq 0 ];then
        echo "suse"    
    elif [ -f $systemFile ];then
        local ORACLE_OS=$(cat ${systemFile}  | grep -i "Oracle")
        if [ -n "${ORACLE_OS}" ]
        then
            echo "oracle"
        else
            echo "unkown"
        fi
    else
        echo "unkown"
    fi
}

function check_main()
{
    local os_type=`is_suse_or_oracle`
	
    if [ "${os_type}" == "unkown" ]
    then
        originalInfo="Current OS is not SUSE or Oracle. No need to check kernel version."
        log INFO "${originalInfo}"
        return 0
    fi
	
    local kernel_version="`uname -r`"    
    local vbs_driver=$(ls ${VBS_KO_PATH}|grep -w "$kernel_version")
    local osd_driver=$(ls ${OSD_KO_PATH}|grep -w "$kernel_version")
    
    if [ "${os_type}" == "suse" ]
    then        
        if [ -z "${vbs_driver}" ] && [ -z "${osd_driver}" ] && [ "$kernel_version" != "3.0.101-0.47.99-default" ] && [ "$kernel_version" != "3.0.101-0.47.105-default" ] && [ "$kernel_version" != "3.0.101-0.47.106.5-default" ] && [ "$kernel_version" != "3.0.101-0.47.106.8-default" ]
        then            
            originalInfo="Current SUSE kernel ${kernel_version} not support driver version."
            log ERROR "${originalInfo}"
            resultCode=1
            errorKey="630001"
            return $resultCode
        fi
        originalInfo="Current SUSE kernel ${kernel_version} support driver version."
        log INFO "${originalInfo}"
        return 0
	fi
	
	if [ "${os_type}" == "oracle" ]
	then        
        if [ -z "${vbs_driver}" ] && [ -z "${osd_driver}" ]
        then            
            originalInfo="Current Oracle kernel ${kernel_version} not support driver version."
            log ERROR "${originalInfo}"
            resultCode=1
            errorKey="630001"
            return $resultCode
        fi
        originalInfo="Current Oracle kernel ${kernel_version} support driver version."
        log INFO "${originalInfo}"
        return 0
	fi
    return 0
}

function main()
{
    if [[ ${tar_version} == V100R006C30SP[CH]60* || ${tar_version} == V100R006C30SPC80* ]]
    then
        log INFO "Target version is ${tar_version}, begin to check ..."
        check_main
    else
        originalInfo="Target version is ${tar_version}, no need to check kernel version."
        log INFO "${originalInfo}"
    fi
    FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
    return "${resultCode}"
}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}
