#!/bin/bash

cd $(dirname $0)
g_curPath="$PWD"
g_scriptName="$(basename $0)"
cd - >> /dev/null

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }

#输出到json文件中的checkItemId,每个检查脚本一个id
checkItemId="35"
resultCode=0
errorKey=""
params=""
originalInfo=""

agentMonitorFile="/opt/dsware/agent/conf/agentMonitor"
clusterInfoFile="/opt/dsware/agent/conf/dsware_cluster_info"
dsware_insight="/opt/dsware/agent/tool/dsware_insight"
dswareAgentTool="/opt/dsware/agent/tool/dsware_agent_tool"

function check_main()
{
    local CNT_MONITOR=$(cat ${agentMonitorFile}  | grep mdc |grep -v alarm | grep -E "True" | wc -l)
    local CNT_MONITOR_MDC=$(cat ${agentMonitorFile} | grep mdc_is_monitor= | wc -l)
    local MDC_STATUS=$(cat "${clusterInfoFile}" | grep "mdc_" | grep "_status=1" | wc -l)

    if [[ "${CNT_MONITOR}" == "0" ]]
    then
        originalInfo="No mdc_is_mornitor=True in ${agentMonitorFile}."
        log INFO "${originalInfo}"

        originalInfo="\n""${originalInfo}""\n""command:cat ${clusterInfoFile} | grep mdc_status= \n""review:$(cat ${clusterInfoFile} | grep mdc_status=) \n"
        originalInfo=${originalInfo}"command:cat ${agentMonitorFile} | grep mdc_is_monitor= \n""review:$(cat ${agentMonitorFile} | grep mdc_is_monitor=)\n"

        if [[ ${CNT_MONITOR_MDC} -ne 0 ]]
        then
            check_mdc_in_cluster
        fi
        return "${resultCode}"
    fi

    local CNT_OK_MDC_PROCESS=""
    declare -i count=0
    for temp in {1..3}
    do
        CNT_OK_MDC_PROCESS="$(${dswareAgentTool} --op query_process_info | grep -w "MDC" | grep -w "OK" | wc -l)"
        originalInfo="$(${dswareAgentTool} --op query_process_info | grep -w "MDC")"
        originalInfo="Monitor mdc number is ${CNT_MONITOR} in ${agentMonitorFile};\n""command: ${dswareAgentTool} --op query_process_info | grep -w MDC""\n${originalInfo}"
        if [ "${CNT_OK_MDC_PROCESS}" -lt "${CNT_MONITOR}" ]
        then
            log ERROR "mdc_status error: monitor_mdc_num=[${CNT_MONITOR}], CNT_OK_MDC_PROCESS=[${CNT_OK_MDC_PROCESS}]."
            ((count++))
            if [ "${count}" -gt 1 ]
            then
                resultCode=1
                errorKey="350001"
            fi
        else
            break
        fi
        sleep 2
    done

    z_process_count=$(ps -e -o stat,cmd | grep -w "dsware_mdc" | grep -v grep | awk '{print $1}' | grep -E "Z"  | wc -l)
    if [ "${z_process_count}" -ne "0" ]; then
        errorInfo="mdc_status error: exist Z status mdc process, z_process_count=[${z_process_count}]."
        log ERROR "${errorInfo}"
        resultCode=1
        errorKey="350001"
        originalInfo="${originalInfo}""\n${errorInfo}"
    fi

    d_process_count=$(ps -e -o stat,cmd | grep -w "dsware_mdc" | grep -v grep | awk '{print $1}' | grep -E "D"  | wc -l)
    if [ "${d_process_count}" -ne "0" ]; then
        errorInfo="mdc_status error: exist D status mdc process, d_process_count=[${d_process_count}]."
        log ERROR "${errorInfo}"
        resultCode=1
        errorKey="350001"
        originalInfo="${originalInfo}""\n${errorInfo}"
    fi

    logInfo="Check mdc process, monitor mdc num:[${CNT_MONITOR}], running mdc num:[${CNT_OK_MDC_PROCESS}]."
    log INFO "${logInfo}"
    originalInfo="${originalInfo}""\n${logInfo}\n"

    check_mdc_in_cluster

    return "${resultCode}"
}

function check_mdc_in_cluster()
{
    mdc_cfg=$(cat /opt/dsware/mdc/conf/mdc_conf.cfg |grep -E 'mdc_id|mdc_ip_2|mdc_port')
    mdc_id=$(echo "${mdc_cfg}" |grep 'mdc_id' |awk -F '=' '{print $2}')
    mdc_ip=$(echo "${mdc_cfg}" |grep 'mdc_ip_2' |awk -F '=' '{print $2}' |awk -F '@' '{print $1}')
    mdc_port=$(echo "${mdc_cfg}" |grep 'mdc_port' |awk -F '=' '{print $2}')

    di_ret_info=$(${dsware_insight} 0 ${mdc_id} ${mdc_ip} ${mdc_port} 8 181)
    ret=$?

    originalInfo="${originalInfo}""command:${dsware_insight} 0 ${mdc_id} ${mdc_ip} ${mdc_port} 8 181""\n""review:\n${di_ret_info}"

    if [[ ${ret} -eq 0 ]]
    then
        log INFO "storage_ip=${mdc_ip} is in current cluster"
        return 0
    else
        resultCode=1
        log ERROR "storage_ip=${mdc_ip} is not in current cluster"
        originalInfo=${originalInfo}"\n""ERROR:storage_ip=${mdc_ip} is not in current cluster."
        [[ -z "${errorKey}" ]] && errorKey="350002" || errorKey="350003"

        return 1
    fi
}

function main()
{
    check_main
    FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
    return "${resultCode}"
}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}
