#!/bin/bash

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }

checkItemId="48"
resultCode=0
errorKey=""
params=""
originalInfo=""

IP_TYPE="ipv4"
NET_WORK_TYPE_FILE="/opt/dsware/agent/conf/network.cfg"

function getNetworkType()
{
    if [ ! -f ${NET_WORK_TYPE_FILE} ];then
        log "ERROR" "networkType file ${NET_WORK_TYPE_FILE} not exist!"
        return 1
    fi

    IP_TYPE=$(cat ${NET_WORK_TYPE_FILE} | grep -w -E "^storage_ipv6" | awk -F '=' '{print $2}')

    if [ "X1" == "X${IP_TYPE}" ];then
        IP_TYPE="ipv6"
    else
        IP_TYPE="ipv4"
    fi

    log INFO "current ip type: ${IP_TYPE}"

    return 0
}

function main()
{
    version=`cat /opt/dsware/DSwareAgentNodeVersion|grep nodeVersion|awk -F '=' '{print $2}'`
    originalInfo="command:cat /opt/dsware/DSwareAgentNodeVersion|grep nodeVersion|awk -F '=' '{print \$2}'\n"
    originalInfo="${originalInfo}""review:${version}\n"

    update_version=$(get_package_version)
    if [[ !(${update_version} =~ "V100R006C30SPC30" || ${update_version} =~ "V100R006C30SPC50") ]]
    then
        originalInfo="${originalInfo}""result:FSA target version ${update_version} no need to check."
        log INFO "${checkItemId}FSA_check_mdc_url.sh:FSA target version  ${update_version} no need to check."
        log INFO "${checkItemId}:FSA_check_mdc_url.sh:ok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

    local agentMonitor="/opt/dsware/agent/conf/agentMonitor"
    vbs_judg=`cat $agentMonitor | grep vbs|grep -v alarm | grep -E "True" | wc -l`  

    if [ $vbs_judg -lt 1 ]
    then
        originalInfo="${originalInfo}""command:cat /opt/dsware/agent/conf/agentMonitor | grep -i vbs >/dev/null 2>&1\n"
        originalInfo="${originalInfo}""review:\$? not equal 0."
        originalInfo="${originalInfo}""result:this web_server is not vbs point."
        log INFO "${checkItemId}FSA_check_mdc_url.sh:this web_server is not vbs point."
        log INFO "${checkItemId}:FSA_check_mdc_url.sh:ok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

    getNetworkType
    local split_flag=""
    
    if [[ ${IP_TYPE} == "ipv6" ]]
    then
        split_flag="-"
    else
        split_flag=":"
    fi
    
    local mdc_ip=`cat /opt/dsware/vbs/conf/vbs_*conf.cfg |grep vbs_mdc_url|awk -F '=' '{print $2}'|awk -F '@' '{print $1}'|awk -F ${split_flag} '{print $2}'`
    originalInfo="${originalInfo}""command:cat /opt/dsware/vbs/conf/vbs_*conf.cfg |grep vbs_mdc_url|awk -F '=' '{print \$2}'|awk -F '@' '{print \$1}'|awk -F ':' '{print \$2}'\n"
    originalInfo="${originalInfo}""review:mdc_ip=${mdc_ip}\n"
    local mdc_id=`cat /opt/dsware/vbs/conf/vbs_*conf.cfg |grep vbs_mdc_url|awk -F '=' '{print $2}'|awk -F '@' '{print $1}'|awk -F ${split_flag} '{print $1}'`
    originalInfo="${originalInfo}""command:cat /opt/dsware/vbs/conf/vbs_*conf.cfg |grep vbs_mdc_url|awk -F '=' '{print \$2}'|awk -F '@' '{print \$1}'|awk -F ':' '{print \$1}'\n"
    originalInfo="${originalInfo}""review:mdc_id=${mdc_id}\n"
    local dsi="/opt/dsware/agent/tool/dsware_insight"
    $dsi 0 $mdc_id $mdc_ip 10530 8 181 2>&1 >/dev/null
    if [ $? -ne 0 ]
    then
        resultCode=2
        errorKey="${checkItemId}0002"    #  0002  dsware_insight 指令执行失败
        originalInfo="${originalInfo}""result:dsware_insight command execution failed."
        log ERROR "${checkItemId}FSA_check_mdc_url.sh:'$dsi 0 $mdc_id $mdc_ip 10530 8 181' command execution failed ."
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi


    local target=`$dsi 0 $mdc_id $mdc_ip 10530 8 181`
    originalInfo="${originalInfo}""command:$dsi 0 $mdc_id $mdc_ip 10530 8 181\n"
    originalInfo="${originalInfo}""review:${target}\n"
    local id_list=`echo "$target"|awk '{print $3}'|grep -v NID|grep -v MDC`
    originalInfo="${originalInfo}""command:echo "$target"|awk '{print \$3}'|grep -v NID|grep -v MDC\n"
    originalInfo="${originalInfo}""review:${id_list}\n"

    for line in ${id_list}
    do
        flag1="=""$line""$split_flag"
        flag2=",""$line""$split_flag"
        num=`cat /opt/dsware/vbs/conf/vbs_*conf.cfg|grep mdc_url|grep -E "$flag1|$flag2" -c`
        if [[ $num -ne 2 ]]
        then
            resultCode=1
            errorKey="${checkItemId}0001"    #  0001 VBS的url和MDC集群的url不一致
            originalInfo="${originalInfo}""command:cat /opt/dsware/vbs/conf/vbs_*conf.cfg|grep mdc_url|grep -E '$flag1|$flag2' -c\n"
            originalInfo="${originalInfo}""review:num not equal 2.\n"
            originalInfo="${originalInfo}""result:id:""$line"" mdc not exist in vbs.conf."
            log ERROR "${checkItemId}FSA_check_mdc_url.sh:$line mdc not exist in vbs.conf."
        fi

    done


    if [[ $resultCode -ne 1 ]]
    then
        originalInfo="${originalInfo}""result:FSA_check_mdc_url.sh:ok"
        log INFO "${checkItemId}:FSA_check_mdc_url.sh:ok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    else
        log ERROR "${checkItemId}:FSA_check_mdc_url.sh:unok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi
}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}

##############################
#
#  错误码：
#  0001 VBS的url和MDC集群的url不一致
#
##############################
