#!/bin/bash

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"
PATH="/sbin:/usr/sbin:/usr/local/sbin:/root/bin:/usr/local/bin:/usr/bin:/bin:/opt/omm/oma/workspace/tools"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/version.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/version.sh failed."; exit 130; }

checkItemId="60"
resultCode=0
errorKey=""
params=""
originalInfo=""

function checkMegaSASLog()
{
    #  日志文件存在，检查一下大小以及是否有充足空间进行转储
    local logSize=$(ll --block-size=1k $script_path/$Log | awk '{print $5}')
    local availableSize=$(df --block-size=1k /var/log/ | tail -n1 | awk '{print $4}')
    if [ $logSize -ge $availableSize ]
    then
        # 转储空间不足
        resultCode=1
        errorKey="${checkItemId}0003"
        originalInfo="command: ls -lk $script_path/$Log\n"
        originalInfo="${originalInfo}""result:`ls -lk $script_path/$Log `\n"
        originalInfo="${originalInfo}""command: df -lk /var/log/\n"
        originalInfo="${originalInfo}""result:\n`df -lk /var/log/`\n"
        originalInfo="${originalInfo}""result:/var/log space(${availableSize}KB) is not enough(${logSize}KB), can not dump MegaSAS.log\n"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi

    # 日志文件存在，检查是否配置了转储
    grep MegaSAS.log /opt/dsware/agent/conf/logrotate >/dev/null 2>&1
    if [ $? -eq 0 ]
    then
        # 转储空间充足且配置了日志转储，通过
        resultCode=0
        log ERROR "${checkItemId}:This node exist $script_path/$Log,but has been moved"
        originalInfo="${originalInfo}""command:grep MegaSAS.log /opt/dsware/agent/conf/logrotate\n"
        originalInfo="${originalInfo}""review:\$?=0\n"
        originalInfo="${originalInfo}""result:This node exist $script_path/$Log,but has been moved.\n"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    else
        # 没有配置转储
        resultCode=1
        errorKey="${checkItemId}0002"
        originalInfo="command:ls $script_path/$Log\n"
        originalInfo="${originalInfo}""result:"`ls $script_path/$Log`"\n"
        originalInfo="${originalInfo}""command:cat /opt/dsware/agent/conf/logrotate\n"
        originalInfo="${originalInfo}""`cat /opt/dsware/agent/conf/logrotate`"
        originalInfo="${originalInfo}""result:Please Check if MegaSAS.log($logSize) can dump to /var/log($availableSize) \n"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"

########日志转储处理

        sed -i '/fsa_heart_beat.log/ s/$/  \/opt\/dsware\/agent\/script\/MegaSAS.log /' /opt/dsware/agent/conf/logrotate
        sh /opt/dsware/agent/script/dswareAgent_tool.sh restart >/dev/null 2>&1
        if [ $? -eq 0 ]
        then
            log INFO "restart FSA sucessfully"
        fi
        return 1
     fi
     return 0
}


function main()
{
    src_version="$(get_src_version)"
    if [[ ! ${src_version} == V100R006C30SPC50[0-1] ]]
    then
        originalInfo="command:get src_version\n"
        originalInfo="${originalInfo}""review:src_version is ${src_version}\n"
        originalInfo="${originalInfo}""result:src_version not belong to V100R006C30SPC50[0-1]."
        log INFO "${checkItemId}FSA_check_mega_log.sh:src_version not belong to V100R006C30SPC50[0-1]."
        log INFO "${checkItemId}:FSA_check_mega_log.sh:ok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    fi

    script_path="/opt/dsware/agent/script"
    Log="MegaSAS.log"
    if [ ! -f $script_path/$Log ]
    then
        resultCode=0
        log INFO "${checkItemId}:This node not exist $script_path/$Log"
        originalInfo="This node not exist $script_path/$Log"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 0
    else
        checkMegaSASLog || return 1
        return 0
     fi
}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}

##############################
#
#  错误码：
#  600001 /opt/dsware/agent/script/MegaSAS.log文件存在，但是已经进行日志转储 ——已经弃用
#  600002 /opt/dsware/agent/script/MegaSAS.log文件存在，而且未进行日志转储
#  600003 /opt/dsware/agent/script/MegaSAS.log转储到/var/log失败，/var/log空间不足
##############################