#!/bin/bash

UPG_LIB_PATH="/opt/omm/oma/atoms/precheck/lib"

source "${UPG_LIB_PATH}/log.sh" || { echo "source ${UPG_LIB_PATH}/log.sh failed."; exit 130; }
source "${UPG_LIB_PATH}/out_put.sh" >> ${LOG_FILE} 2>&1 || { log ERROR "source ${UPG_LIB_PATH}/out_put.sh failed."; exit 130; }

checkItemId="54"
resultCode=0
errorKey=""
params=""
originalInfo=""

main()
{
    total_memory_free=0
    free_memory_only=0
    cached_memory=0
    buffers_memory=0

    if [[ -f "/etc/SuSE-release" ]]
    then
        free_memory_only=`free -g | grep -i mem | awk '{print$4}'`
        originalInfo="${originalInfo}""command:free -g | grep -i mem | awk '{print\$4}'\n"
        originalInfo="${originalInfo}""review:free_memory_only is ${free_memory_only}G\n"
        cached_memory=`free -g | grep -i mem | awk '{print$7}'`
        originalInfo="${originalInfo}""command:free -g | grep -i mem | awk '{print\$7}'\n"
        originalInfo="${originalInfo}""review:cached_memory is ${cached_memory}G\n"
        buffers_memory=`free -g | grep -i mem | awk '{print$6}'`
        originalInfo="${originalInfo}""command:free -g | grep -i mem | awk '{print\$6}'\n"
        originalInfo="${originalInfo}""review:buffers_memory is ${buffers_memory}G\n"
        total_memory_free=$[${free_memory_only}+${cached_memory}+${buffers_memory}]
    elif [[ -f "/etc/redhat-release" ]]
    then
        free_memory_only=`free -g | grep -i mem | awk '{print$4}'`
        originalInfo="${originalInfo}""command:free -g | grep -i mem | awk '{print\$4}'\n"
        originalInfo="${originalInfo}""review:free_memory_only is ${free_memory_only}G\n"
        buffers_memory=`free -g | grep -i mem | awk '{print$6}'`
        originalInfo="${originalInfo}""command:free -g | grep -i mem | awk '{print\$6}'\n"
        originalInfo="${originalInfo}""review:buffers_memory is ${buffers_memory}G\n"
        total_memory_free=$[${free_memory_only}+${buffers_memory}]
    else
        free_memory_only=`free -g | grep -i mem | awk '{print$4}'`
        originalInfo="${originalInfo}""command:free -g | grep -i mem | awk '{print\$4}'\n"
        originalInfo="${originalInfo}""review:free_memory_only is ${free_memory_only}G\n"
        cached_memory=`free -g | grep -i mem | awk '{print$7}'`
        originalInfo="${originalInfo}""command:free -g | grep -i mem | awk '{print\$7}'\n"
        originalInfo="${originalInfo}""review:cached_memory is ${cached_memory}G\n"
        buffers_memory=`free -g | grep -i mem | awk '{print$6}'`
        originalInfo="${originalInfo}""command:free -g | grep -i mem | awk '{print\$6}'\n"
        originalInfo="${originalInfo}""review:buffers_memory is ${buffers_memory}G\n"
        total_memory_free=$[${free_memory_only}+${cached_memory}+${buffers_memory}]
    fi
    originalInfo="${originalInfo}""result:total free memory is ${total_memory_free}G\n"
    log INFO "total_memory_free is ${total_memory_free}G"

    total_memory=`free -g | grep -i mem | awk '{print$2}'`
    originalInfo="${originalInfo}""command:free -g | grep -i mem | awk '{print\$2}'\n"
    originalInfo="${originalInfo}""review:total memory is ${total_memory}\n"
    log INFO "Total memory is ${total_memory}G"

    result_tmp=$(awk 'BEGIN{printf "%.2f\n",('${total_memory_free}'/'${total_memory}')}')
    originalInfo="${originalInfo}""command:awk 'BEGIN{printf %f,('${total_memory_free}'/'${total_memory}'}'\n"
    originalInfo="${originalInfo}""review:${result_tmp}\n"
    log INFO "Remaining percentage:${result_tmp}"

    result=$(awk 'BEGIN{printf "%d\n",'${result_tmp}*100'}')
    if [ ${result} -ge 20 ] || [ ${total_memory_free} -ge 10 ]
    then
        originalInfo="${originalInfo}""result:remain of memory is enough."
        log INFO "result:remain of memory is enough."
        log INFO "${checkItemId}FSA_check_memory_remain.sh:ok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
    else
        resultCode=1
        errorKey="${checkItemId}0001"    #  0001  系统内存剩余不足
        originalInfo="${originalInfo}""result:remain of memory is not enough."
        log ERROR "result:remain of memory is not enough."
        log ERROR "${checkItemId}FSA_check_memory_remain.sh:unok"
        FSA_json_output "${checkItemId}" "${resultCode}" "${errorKey}" "${params}" "${originalInfo}"
        return 1
    fi

}

log MUST "enter [$0],para=[$@]"
main $@
retValue=$?
log MUST "leave [$0],retValue=${retValue}"
exit ${retValue}

##############################
#
#  错误码：
#    0001  系统内存剩余不足
#
##############################